% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_group.R
\name{groupmorph.split.hemilist}
\alias{groupmorph.split.hemilist}
\title{Split a per-vertex group data matrix for both hemispheres into a hemilist at given index.}
\usage{
groupmorph.split.hemilist(data, numverts_lh)
}
\arguments{
\item{data}{numerical matrix or dataframe of per-vertex data, with subjects in columns}

\item{numverts_lh}{scalar positive integer, the number of vertices in the left hemisphere mesh (defining the index where to split).}
}
\value{
\code{\link[fsbrain]{hemilist}} of the data, split at the index.
}
\description{
Split a per-vertex group data matrix for both hemispheres into a hemilist at given index.
}
\examples{
\dontrun{
   fsbrain::download_optional_data();
   fsbrain::download_fsaverage(TRUE);
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   subjects_list = c("subject1", "subject2");
   data = group.morph.standard(subjects_dir, subjects_list, "thickness", "lh", fwhm='10');
   numverts_lh = subject.num.verts(subjects_dir, "fsaverage", hemi="lh");
   data_hemilist = groupmorph.split.hemilist(data, numverts_lh);
}

}
