% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight.vertices.on.subject.spheres}
\alias{highlight.vertices.on.subject.spheres}
\title{Highlight vertices given by index on a subject's meshes by coloring faces.}
\usage{
highlight.vertices.on.subject.spheres(
  subjects_dir,
  vis_subject_id,
  vertices,
  surface = "white",
  patch_size = 25,
  show_patch = TRUE,
  style = "glass2",
  export_img = NULL,
  sphere_colors = c("#FF0000"),
  sphere_radius = 3,
  ...
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{vis_subject_id}{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{vertices}{positive integer vector, the vertex indices over both hemispheres. Alternative to using verts_lh and verts_rh parameters, only one of them must be used at once.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{patch_size}{double, geodesic radius in which to draw a patch on the mesh around the verts. Pass \code{NULL} to disable.}

\item{show_patch}{logical (or a vector with one logical value per entry in 'vertices'), whether to show colored geodesic patches at the highlighted vertices.}

\item{style}{character string or rgl rendering style, see \code{\link[fsbrain]{get.rglstyle}}.}

\item{export_img}{character string, the path to the output image if you want to export a high-quality image, NULL if you want live visualization instead.}

\item{sphere_colors}{the sphere colors like '#FF0000', can be a single one for all or one per sphere}

\item{sphere_radius}{double, a single radius for all spheres}

\item{...}{extra parameters passed on to \code{\link[fsbrain]{vis.data.on.subject}}. Use this to set a custom colormap etc.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization. If export_img is set, the export return value is returned instead.
}
\description{
Highlight vertices given by index on a subject's meshes by coloring faces.
}
\note{
If no patches are visualized, the color used for the brain can be set with \code{options("fsbrain.brain_na_color"="#FF0000")}.
}
\examples{
\dontrun{
   fsbrain::download_fsaverage(T);
   subjects_dir = fsaverage.path();
   mkco = list('colFn'=viridis::viridis, 'n'=300);
   # Ex.1: highlight with patches and custom colormap:
   highlight.vertices.on.subject.spheres(subjects_dir, 'fsaverage',
     vertices=c(300, 5000, 100000), makecmap_options = mkco);
   # Ex.2: show patches on some (red) vertices, not on blue ones:
   highlight.vertices.on.subject.spheres(subjects_dir, 'fsaverage',
     vertices=c(300, 5000, 100000, 300000), show_patch = c(T,F,T,F),
     sphere_colors = c("red", "blue", "red", "blue"));
}

}
\seealso{
Other visualization functions: 
\code{\link{highlight.vertices.on.subject}()},
\code{\link{vis.color.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.annot}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.subject.morph.standard}()},
\code{\link{vis.subject.pre}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}

Other surface visualization functions: 
\code{\link{highlight.vertices.on.subject}()},
\code{\link{vis.color.on.subject}()}
}
\concept{surface visualization functions}
\concept{visualization functions}
