% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{vertex.hemis}
\alias{vertex.hemis}
\title{Return the proper hemi string ('lh' or 'rh') for each vertex.}
\usage{
vertex.hemis(surface, vertices)
}
\arguments{
\item{surface}{hemilist of surfaces or a single integer which will be interpreted as the vertex count of the left hemisphere.}

\item{vertices}{vector of positive integers, the query vertex indices. Can be in range \code{1..(nv(lh)+nv(rh))}, i.e., across the whole brain.}
}
\value{
vector of character strings, each string is 'lh' or 'rh'.
}
\description{
Return the proper hemi string ('lh' or 'rh') for each vertex.
}
\note{
It is not checked in any way whether the vertex indices are out of bounds on the upper side (higher than the highest rh vertex index).
}
\examples{
  vertex.hemis(100L, vertices=c(99L, 100L, 101L));

}
