% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/functional-spectral-density.R
\name{SpecMA}
\alias{SpecMA}
\title{'Spectral density operator of a MA vector process' Object}
\usage{
SpecMA(a, nfreq = 2^9, noise.type)
}
\arguments{
\item{a}{the filter of the moving average}

\item{nfreq}{the number of frequencies between 0 and pi at which the
spectral density has to be computed}

\item{noise.type}{the type of noise that is driving the MA process. See
\code{\link{Simulate_new_MA}}}
}
\description{
'Spectral density operator of a MA vector process' Object
}
\examples{
ma.scale1=c(-1.4,2.3,-2)
a1=Generate_filterMA(6, 6, MA.len=3, ma.scale=ma.scale1)
a1.spec=SpecMA(a1, nfreq=512, noise.type='wiener')
plot(a1.spec)
rm(a1, a1.spec)
}

