% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parents.R
\name{get_parents}
\alias{get_parents}
\title{Get Parent Nodes from a Given Node}
\usage{
get_parents(node, node_list)
}
\arguments{
\item{node}{A vector representing a single node whose parents are to be found. 
It is expected to contain the elements that may be present in the parent nodes.}

\item{node_list}{A list of vectors, where each vector represents a node in the hierarchical structure. 
The function will search through these nodes to find parents of the specified node.}
}
\value{
A numeric vector containing the indices of the parent nodes in the `node_list` that include the specified node.
}
\description{
This function identifies the parent nodes of a given node in a hierarchical structure. 
It checks which nodes in the provided list contain the specified node, thereby determining 
its parent nodes.
}
\details{
The function works by applying a logical check across the `node_list`. It returns the indices of all nodes 
that contain all elements of the specified node vector. If no parent nodes are found, the function will return 
an empty integer vector.
}
