% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_pca.mfd.R
\name{predict.pca_mfd}
\alias{predict.pca_mfd}
\title{Predict from a multivariate functional PCA}
\usage{
\method{predict}{pca_mfd}(
  object,
  newdata = NULL,
  components = seq_len(ncol(object$pcscores)),
  type = c("scores", "reconstruction"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{"pca_mfd"}, typically the output of
\code{\link{pca_mfd}}.}

\item{newdata}{An object of class \code{"mfd"} containing the new
multivariate functional data to be projected. If \code{NULL}, the training
data used to fit \code{object} are used.}

\item{components}{Integer vector specifying the indices of the principal
components to use. Defaults to all available components.}

\item{type}{Character string: either \code{"scores"} (default) to return the
scores of \code{newdata}, or \code{"reconstruction"} to return the data
reconstructed from the selected components.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
\itemize{
\item If \code{type = "scores"}, a numeric matrix of dimension
\eqn{nobs \times length(components)}.
\item If \code{type = "reconstruction"}, an object of class \code{"mfd"}.
}
}
\description{
Computes either the scores of new observations on selected principal
components, or their reconstruction from the selected components,
given a PCA fitted by \code{\link{pca_mfd}}.
}
\details{
This function is an S3 method for objects of class \code{"pca_mfd"}.
It is usually called via the generic \code{\link{predict}} function.

The new data are first centered and (optionally) scaled using the functional
center and scale stored in the PCA object.
\itemize{
\item If \code{type = "scores"}, inner products with the selected eigenfunctions
are computed and summed across basis functions.
\item If \code{type = "reconstruction"}, the predicted functional data are
reconstructed from the scores and harmonics.
}
}
\seealso{
\code{\link{pca_mfd}}, \code{\link{scale_mfd}}
}
