% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adfCov.R
\name{adfCov}
\alias{adfCov}
\title{Asymptotic Distribution-Free Covariance Matrix of Covariances}
\usage{
adfCov(X, y = NULL)
}
\arguments{
\item{X}{Data matrix.}

\item{y}{Optional vector of criterion scores.}
}
\value{
\item{adfCovMat}{Asymptotic distribution-free estimate of the
covariance matrix of covariances}
}
\description{
Function for computing an asymptotic distribution-free covariance matrix of
covariances.
}
\examples{

## Generate non-normal data using monte1
set.seed(123)

## we will simulate data for 1000 subjects
N <- 1000

## R = the desired population correlation matrix among predictors
R <- matrix(c(1, .5, .5, 1), 2, 2)

## Consider a regression model with coefficient of determination (Rsq):
Rsq <- .50

## and vector of standardized regression coefficients
Beta <- sqrt(Rsq/t(sqrt(c(.5, .5))) \%*\% R \%*\% sqrt(c(.5, .5))) * sqrt(c(.5, .5))

## generate non-normal data for the predictors (X)
## x1 has expected skew = 1 and kurtosis = 3
## x2 has expected skew = 2 and kurtosis = 5
X <- monte1(seed = 123, nvar = 2, nsub = N, cormat = R, skewvec = c(1, 2), 
           kurtvec = c(3, 5))$data
           
## generate criterion scores 
y <- X \%*\% Beta + sqrt(1-Rsq)*rnorm(N)

## Create ADF Covariance Matrix of Covariances
adfCov(X, y)

#>         11       12       13       22       23       33
#> 11 3.438760 2.317159 2.269080 2.442003 1.962584 1.688631
#> 12 2.317159 3.171722 2.278212 3.349173 2.692097 2.028701
#> 13 2.269080 2.278212 2.303659 2.395033 2.149316 2.106310
#> 22 2.442003 3.349173 2.395033 6.275088 4.086652 2.687647
#> 23 1.962584 2.692097 2.149316 4.086652 3.287088 2.501094
#> 33 1.688631 2.028701 2.106310 2.687647 2.501094 2.818664
}
\references{
Browne, M. W. (1984). Asymptotically distribution-free methods
for the analysis of covariance structures. \emph{British Journal of
Mathematical and Statistical Psychology, 37,} 62--83.
}
\author{
Jeff Jones and Niels Waller
}
\keyword{Statistics}
