% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HashTable.R
\name{HashTable}
\alias{HashTable}
\title{Class HashTable}
\description{
Hashtable to contain object modalities. Storage objects like \link{Training} and \link{TrainLayer} are extensions of this class.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HashTable-new}{\code{HashTable$new()}}
\item \href{#method-HashTable-print}{\code{HashTable$print()}}
\item \href{#method-HashTable-add2HashTable}{\code{HashTable$add2HashTable()}}
\item \href{#method-HashTable-getFromHashTable}{\code{HashTable$getFromHashTable()}}
\item \href{#method-HashTable-getKeyClass}{\code{HashTable$getKeyClass()}}
\item \href{#method-HashTable-removeFromHashTable}{\code{HashTable$removeFromHashTable()}}
\item \href{#method-HashTable-getId}{\code{HashTable$getId()}}
\item \href{#method-HashTable-getHashTable}{\code{HashTable$getHashTable()}}
\item \href{#method-HashTable-checkClassExist}{\code{HashTable$checkClassExist()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-new"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-new}{}}}
\subsection{Method \code{new()}}{
Initialize a default parameters list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$new(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
ID of the hash table. It must be unique.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-print"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-add2HashTable"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-add2HashTable}{}}}
\subsection{Method \code{add2HashTable()}}{
Function to add a key-value pair to the hash table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$add2HashTable(key, value, .class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{\code{character} \cr
The key to be added.}

\item{\code{value}}{\code{object} \cr
Object to be added.}

\item{\code{.class}}{\code{character} \cr
Class of the object to be added.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-getFromHashTable"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-getFromHashTable}{}}}
\subsection{Method \code{getFromHashTable()}}{
Getter of the object which the key passed as argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$getFromHashTable(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{\code{character} \cr
Key of the required object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-getKeyClass"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-getKeyClass}{}}}
\subsection{Method \code{getKeyClass()}}{
Getter of the \code{data.frame} that stores all key class pairs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$getKeyClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-removeFromHashTable"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-removeFromHashTable}{}}}
\subsection{Method \code{removeFromHashTable()}}{
Remove the object with the corresponding key from the hashtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$removeFromHashTable(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Key of the object to be removed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-getId"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-getId}{}}}
\subsection{Method \code{getId()}}{
Getter of the current object ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$getId()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-getHashTable"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-getHashTable}{}}}
\subsection{Method \code{getHashTable()}}{
Getter of the current hashtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$getHashTable()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HashTable-checkClassExist"></a>}}
\if{latex}{\out{\hypertarget{method-HashTable-checkClassExist}{}}}
\subsection{Method \code{checkClassExist()}}{
Check whether object from a class has already been stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HashTable$checkClassExist(.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{.class}}{\code{character} \cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean value
}
}
}
