# WARNING - Generated by {fusen} from dev/flat_inflate_all_utils.Rmd: do not edit by hand # nolint: line_length_linter.

#' Eval message, warning and error from the diagnostic table
#'
#' @param diag_table Diagnostic table from `pre_inflate_all_diagnosis()`
#' @param type_stop Logical. Wether to ouput type stop or others
#'
#' @return Side effect: messages, or errors
#'
#' @noRd
#' @examples
#' # pre_inflate_all_diagnosis_eval()
pre_inflate_all_diagnosis_eval <- function(diag_table, type_stop = FALSE) {
  if (nrow(diag_table) == 0) {
    stop("No file to inflate")
  }

  if (isTRUE(type_stop)) {
    diag_to_eval <- diag_table[diag_table[["type"]] == "stop", ]
  } else {
    diag_to_eval <- diag_table[diag_table[["type"]] != "stop", ]
  }
  if (nrow(diag_to_eval) == 0) {
    return(NULL)
  }

  for (flat_file_diag in 1:nrow(diag_to_eval)) {
    # do.call(
    #   diag[["type"]][flat_file_diag],
    #   list(diag[["status"]][flat_file_diag])
    # )
    params <- diag_to_eval[["params"]][flat_file_diag]
    if (is.na(params)) {
      status_text <- paste0(
        diag_to_eval[["type"]][flat_file_diag],
        "(\"",
        diag_to_eval[["status"]][flat_file_diag],
        "\")"
      )
    } else {
      status_text <- paste0(
        diag_to_eval[["type"]][flat_file_diag],
        "(\"",
        diag_to_eval[["status"]][flat_file_diag],
        "\", ",
        diag_to_eval[["params"]][flat_file_diag],
        ")"
      )
    }

    eval(parse(text = status_text))
  }
}
