% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_local.R
\name{batchtools_local}
\alias{batchtools_local}
\title{A batchtools backend that resolves futures sequentially in transient background R sessions}
\usage{
batchtools_local(
  ...,
  fs.latency = 0,
  delete = getOption("future.batchtools.delete", "on-success")
)
}
\arguments{
\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}

\item{\ldots}{Not used.}
}
\description{
The batchtools local backend is useful for verifying parts of your
\pkg{batchtools} setup locally, before using a more advanced backend such
as the job-scheduler backends.
}
\details{
Batchtools local futures use \pkg{batchtools} cluster functions
created by \code{\link[batchtools:makeClusterFunctionsInteractive]{batchtools::makeClusterFunctionsInteractive()}} with
\code{external = TRUE}.

An alternative to the batchtools interactive backend is to use
\code{plan(future::cluster, workers = I(1))}.
}
\examples{
library(future)
plan(future.batchtools::batchtools_local)

message("Main process ID: ", Sys.getpid())

f <- future({
  data.frame(
    hostname = Sys.info()[["nodename"]],
          os = Sys.info()[["sysname"]],
       cores = unname(parallelly::availableCores()),
         pid = Sys.getpid(),
     modules = Sys.getenv("LOADEDMODULES")
  )
})
info <- value(f)
print(info)

}
