% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma.R
\name{sigma.galamm}
\alias{sigma.galamm}
\title{Extract square root of dispersion parameter from galamm object}
\usage{
\method{sigma}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm}, returned from
\code{\link{galamm}}.}

\item{...}{Optional parameters passed on to other methods. Currently not
used.}
}
\value{
The square root of one or more dispersion parameters.
}
\description{
Extracts the square root of the dispersion parameter(s) from an object of
class \code{galamm}, returned from \code{\link{galamm}}. In the case of
conditionally Gaussian responses, this is the residual standard deviation.
When there are multiple dispersion parameters, e.g., with mixed response
type models, the square root of all of them are returned in a numeric vector.
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract residual standard deviation.
sigma(mod)

# The residual standard deviation applies to the base case. The variance
# function shown in the model output shows the estimated multiplier for
# various grouping levels:
summary(mod)

}
\seealso{
\code{\link[=galamm]{galamm()}}

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
