% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{basic_info}
\alias{basic_info}
\title{Allele and genotype frequencies}
\usage{
basic_info(inputFile, outputFile = "", verbose = interactive())
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{outputFile}{character: The path of the output file}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Allele and genotype frequencies per locus and per sample. See \href{../doc/all-menu-options.html#sub-option-1-allele-and-genotype-frequencies}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
locinfile <- genepopExample('sample.txt')
basic_info(locinfile,'sample.txt.INF')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
