% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_textsmooth.R
\name{geom_textsmooth}
\alias{geom_textsmooth}
\alias{geom_labelsmooth}
\title{Labelled conditional means in \pkg{ggplot2}}
\usage{
geom_textsmooth(
  mapping = NULL,
  data = NULL,
  stat = "smooth",
  position = "identity",
  ...,
  method = NULL,
  formula = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_labelsmooth(
  mapping = NULL,
  data = NULL,
  stat = "smooth",
  position = "identity",
  method = NULL,
  formula = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer}}. These are often aesthetics, used to set an aesthetic to a fixed value, like \code{colour = "red"} or \code{size = 3}. These can also be the following text-path parameters:\describe{\item{\code{text_only}}{A \code{logical(1)} indicating whether the path part should be plotted along with the text (\code{FALSE}, the default). If \code{TRUE}, any parameters or aesthetics relating to the drawing of the path will be ignored.}\item{\code{gap}}{A \code{logical(1)} which if \code{TRUE}, breaks the path into two sections with a gap on either side of the label. If \code{FALSE}, the path is plotted as a whole. Alternatively, if \code{NA}, the path will be broken if the string has a \code{vjust} between 0 and 1, and not otherwise. The default for the label variant is \code{FALSE} and for the text variant is \code{NA}.}\item{\code{upright}}{A \code{logical(1)} which if \code{TRUE} (default), inverts any text where the majority of letters would upside down along the path, to improve legibility. If \code{FALSE}, the path decides the orientation of text.}\item{\code{halign}}{A \code{character(1)} describing how multi-line text should be justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}\item{\code{offset}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the offset of the text from the path. If this is \code{NULL} (default), the \code{vjust} parameter decides the offset. If not \code{NULL}, the \code{offset} argument overrules the \code{vjust} setting.}\item{\code{parse}}{A \code{logical(1)} which if \code{TRUE}, will coerce the labels into expressions, allowing for plotmath syntax to be used.}\item{\code{straight}}{A \code{logical(1)} which if \code{TRUE}, keeps the letters of a label on a straight baseline and if \code{FALSE} (default), lets individual letters follow the curve. This might be helpful for noisy paths.}\item{\code{padding}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the padding between the text and the path when the \code{gap} parameter trims the path.}\item{\code{text_smoothing}}{a \code{numeric(1)} value between 0 and 100 that smooths the text without affecting the line portion of the geom. The default value of \code{0} means no smoothing is applied.}\item{\code{rich}}{A \code{logical(1)} whether to interpret the text as html/markdown formatted rich text. Default: \code{FALSE}. See also the rich text section of the details in \code{\link[=geom_textpath]{geom_textpath()}}.}\item{\code{remove_long}}{if TRUE, labels that are longer than their associated path will be removed.}}}

\item{method}{Smoothing method (function) to use, accepts either
\code{NULL} or a character vector, e.g. \code{"lm"}, \code{"glm"}, \code{"gam"}, \code{"loess"}
or a function, e.g. \code{MASS::rlm} or \code{mgcv::gam}, \code{stats::lm}, or \code{stats::loess}.
\code{"auto"} is also accepted for backwards compatibility.  It is equivalent to
\code{NULL}.

For \code{method = NULL} the smoothing method is chosen based on the
size of the largest group (across all panels). \code{\link[stats:loess]{stats::loess()}} is
used for less than 1,000 observations; otherwise \code{\link[mgcv:gam]{mgcv::gam()}} is
used with \code{formula = y ~ s(x, bs = "cs")} with \code{method = "REML"}. Somewhat anecdotally,
\code{loess} gives a better appearance, but is \eqn{O(N^{2})}{O(N^2)} in memory,
so does not work for larger datasets.

If you have fewer than 1,000 observations but want to use the same \code{gam()}
model that \code{method = NULL} would use, then set
\verb{method = "gam", formula = y ~ s(x, bs = "cs")}.}

\item{formula}{Formula to use in smoothing function, eg. \code{y ~ x},
\code{y ~ poly(x, 2)}, \code{y ~ log(x)}. \code{NULL} by default, in which case
\code{method = NULL} implies \code{formula = y ~ x} when there are fewer than 1,000
observations and \code{formula = y ~ s(x, bs = "cs")} otherwise.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \code{Layer} ggproto object that can be added to a plot.
}
\description{
Smoothed conditional means are available
in \pkg{ggplot2} via \code{\link[ggplot2:geom_smooth]{geom_smooth}}. This geom
layer simply adds a text label to each curve that follow the contour of
this line when used as a drop-in replacement for
\code{\link[ggplot2:geom_smooth]{geom_smooth}}
}
\section{Aesthetics}{

\code{geom_textdensity()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{label}}
  \item \code{alpha}
  \item \code{angle}
  \item \code{colour}
  \item \code{family}
  \item \code{fontface}
  \item \code{group}
  \item \code{hjust}
  \item \code{linecolour}
  \item \code{lineheight}
  \item \code{linetype}
  \item \code{linewidth}
  \item \code{size}
  \item \code{spacing}
  \item \code{textcolour}
  \item \code{vjust}
}
In addition to aforementioned aesthetics, \code{geom_labeldensity()} also understands:
\itemize{
  \item \code{boxcolour}
  \item \code{boxlinetype}
  \item \code{boxlinewidth}
  \item \code{fill}
}
The \code{spacing} aesthetic allows fine control of spacing
 of text, which is called 'tracking' in typography.
The default is 0 and units are measured in 1/1000 em.
Numbers greater than zero increase the spacing,
whereas negative numbers decrease the spacing.


Learn more about setting these aesthetics 
in \code{vignette("ggplot2-specs")}.
}

\examples{
ggplot(iris, aes(x = Sepal.Length, y = Petal.Length)) +
  geom_point(alpha = 0.1) +
  geom_textsmooth(aes(label = Species, colour = Species),
                method = "loess", formula = y ~ x,
                size = 7, linetype = 3, fontface = 2, linewidth = 1) +
  scale_colour_manual(values = c("forestgreen", "deepskyblue4", "tomato4")) +
  theme_bw() +
  theme(legend.position = "none")
}
\seealso{
Other \link[=sibling_layers]{geom layers} that place text on paths.
}
