% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/craft-align-order.R
\name{align_order}
\alias{align_order}
\title{Order observations based on weights}
\usage{
align_order(
  weights = rowMeans,
  ...,
  reverse = FALSE,
  strict = TRUE,
  data = NULL,
  active = NULL
)
}
\arguments{
\item{weights}{A summary function which accepts a data and returns the
weights for each observations. Alternatively, you can provide an ordering
index as either an integer or a character. Since characters have been
designated as character indices, if you wish to specify a function name as a
string, you must enclose it with \code{\link[=I]{I()}}.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
function provided in \code{weights} argument.}

\item{reverse}{A boolean value. Should the sort order be in reverse?}

\item{strict}{A boolean value indicates whether the order should be strict.
If previous groups has been established, and strict is \code{FALSE}, this will
reorder the observations in each group.}

\item{data}{A \code{matrix}, \verb{data frame}, or atomic vector used as the input for
the \code{weights} function. Alternatively, you can specify a \code{function}
(including purrr-like lambda syntax) that will be applied to the layout
matrix, transforming it as necessary for weight calculations. By default, it
will inherit from the layout matrix.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Ordering observations based on summary weights or a specified ordering
character or integer index.
}
\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_left() +
    align_order(I("rowMeans"))
}
