% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_circle_repel.R
\docType{data}
\name{position_circle_repel}
\alias{position_circle_repel}
\alias{position_circle_repel_sf}
\alias{PositionCircleRepel}
\alias{PositionCircleRepelSf}
\title{Pack overlapping points into a circle}
\usage{
position_circle_repel(scale = 1/4)

position_circle_repel_sf(scale = 10)
}
\arguments{
\item{scale}{Scale of packing around the central point.
This is in data units, so for the \code{_sf} variant it will depend on the
units specified by the coordinate reference system.}
}
\value{
A ggplot position object.
}
\description{
This position looks for any points with identical \code{x} and \code{y}
positions and packs them in a circle around the original point. The \code{_sf}
version applies the position adjustment in projected coordinates.
}
\details{
Note that extreme choices of \code{scale} may cause errors.

The \code{scale} parameter can instead be specified as an aesthetic for geoms
that support it (\code{\link[=geom_centroids]{geom_centroids()}}). This allows different locations to have
different scales, which is especially useful when combined with map insets.
}
\examples{
library(ggplot2)

points <- data.frame(
  x = c(rep(1, 10), 1:3),
  y = c(rep(2, 10), 3:5),
  s = 0.05
)
ggplot(points, aes(x, y)) +
  geom_point(size = 3, colour = "red") +
  geom_point(position = position_circle_repel(0.05), size = 3, alpha = 0.5)

cartographer::nc_type_example_2 |>
  dplyr::filter(!county \%in\% c("HENDERSON", "GASTON", "LINCOLN")) |>
  ggplot(aes(location = county)) +
  geom_boundaries(feature_type = "sf.nc") +
  geom_centroids(aes(colour = type), position = position_circle_repel_sf(scale = 4), size = 0.2) +
  coord_automap(feature_type = "sf.nc")
}
\keyword{datasets}
