% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_alpha_focus.R, R/scale_color_focus.R,
%   R/scale_fill_focus.R, R/scale_linetype_focus.R, R/scale_shape_focus.R,
%   R/scale_size_focus.R, R/zzz.R
\name{scale_alpha_focus}
\alias{scale_alpha_focus}
\alias{scale_focus}
\alias{scale_color_focus}
\alias{scale_fill_focus}
\alias{scale_linetype_focus}
\alias{scale_shape_focus}
\alias{scale_size_focus}
\alias{scale_colour_focus}
\title{Focus scales for `ggplot` objects}
\usage{
scale_alpha_focus(focus_levels, alpha_focus = 1, alpha_other = 0.2)

scale_color_focus(
  focus_levels,
  color_focus = NULL,
  color_other = "gray",
  palette_focus = "Set1"
)

scale_fill_focus(
  focus_levels,
  color_focus = NULL,
  color_other = "gray",
  palette_focus = "Set1"
)

scale_linetype_focus(focus_levels, linetype_focus = 1, linetype_other = 3)

scale_shape_focus(focus_levels, shape_focus = 8, shape_other = 1)

scale_size_focus(focus_levels, size_focus = 3, size_other = 1)
}
\arguments{
\item{focus_levels}{character vector with levels to focus on.}

\item{alpha_focus}{`alpha` value for focused levels. Defaults to 1.}

\item{alpha_other}{`alpha` value for other levels. Defaults to 0.05.}

\item{color_focus}{color(s) for focused levels (a single value or a vector
with the same length as the number of highlighted levels).}

\item{color_other}{color for other levels.}

\item{palette_focus}{If `color_focus` is not specified, provide a pelette
from RColorBrewer to pick colors.}

\item{linetype_focus}{vector of `linetype` value(s) for focused levels with
length 1 or equal to `focus_levels`. Defaults to 1.}

\item{linetype_other}{`linetype` value for other levels. Defaults to 3.}

\item{shape_focus}{`shape` value for focused levels. Defaults to 8.}

\item{shape_other}{`shape` value for other levels. Defaults to 1.}

\item{size_focus}{`size` value for focused levels. Defaults to 3.}

\item{size_other}{`size` value for other levels. Defaults to 1.}
}
\description{
Scale that focus on specific levels.
}
\note{
Use \code{RColorBrewer::display.brewer.all()} to see the palettes
available.
}
\examples{
ggplot(iris, aes(x = Petal.Length, y = Sepal.Length, alpha = Species)) +
 geom_point() +
 scale_alpha_focus(focus_levels = "versicolor")


ggplot(iris, aes(x = Petal.Length, y = Sepal.Length, color = Species)) +
 geom_point() +
 scale_color_focus(focus_levels = "setosa", color_focus = "red")

ggplot(iris, aes(x = Petal.Length, y = Sepal.Length, color = Species)) +
 geom_point() +
 scale_color_focus(focus_levels = c("setosa", "virginica"), color_focus = c("red", "blue"))

ggplot(mtcars, aes(x = wt, y = mpg, color = rownames(mtcars))) +
 geom_point() +
 scale_color_focus(focus_levels = c("Mazda RX4", "Merc 230"), palette_focus = "Set2")

ggplot(iris,aes(x = Petal.Length, group = Species, fill = Species)) +
  geom_histogram() +
  scale_fill_focus(focus_levels = "versicolor", color_focus = "red")

ggplot(iris,aes(x = Petal.Length, y = Sepal.Length, shape = Species)) +
 geom_point() +
 scale_shape_focus(focus_levels = "versicolor")


ggplot(iris,aes(x = Petal.Length, y = Sepal.Length, size = Species)) +
 geom_point() +
 scale_size_focus(focus_levels = "versicolor")


}
