% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcConnectionsHelpers.R
\name{getMidpoints}
\alias{getMidpoints}
\title{Compute midpoints across grouped coordinates}
\usage{
getMidpoints(
  data,
  group_vars,
  x_vars,
  y_vars,
  x_out,
  y_out,
  method = "mean",
  require_non_missing = group_vars
)
}
\arguments{
\item{data}{A `data.frame` containing the coordinate and grouping variables.}

\item{group_vars}{Character vector. Names of the grouping variables.}

\item{x_vars}{Character vector. Names of the x-coordinate variables to be averaged.}

\item{y_vars}{Character vector. Names of the y-coordinate variables to be averaged.}

\item{x_out}{Character. Name of the output column for the x-coordinate midpoint.}

\item{y_out}{Character. Name of the output column for the y-coordinate midpoint.}

\item{method}{Character. Method for calculating midpoints. Options include:
\itemize{
\item `"mean"`: Arithmetic mean of the coordinates.
\item `"median"`: Median of the coordinates.
\item `"weighted_mean"`: Weighted mean of the coordinates.
\item `"first_pair"`: Mean of the first pair of coordinates.
\item `"meanxfirst"`: Mean of the x-coordinates and first y-coordinate.
\item `"meanyfirst"`: Mean of the y-coordinates and first x-coordinate.
}}

\item{require_non_missing}{Character vector. Names of variables that must not be missing for the row to be included.}
}
\value{
A `data.frame` grouped by `group_vars` with new columns `x_out` and `y_out` containing midpoint coordinates.
}
\description{
A flexible utility function to compute x and y midpoints for groups of individuals
using a specified method. Used to support positioning logic for sibling groups,
parental dyads, or spousal pairs in pedigree layouts.
}
\keyword{internal}
