% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glossa_analysis.R
\name{glossa_analysis}
\alias{glossa_analysis}
\title{Main Analysis Function for GLOSSA Package}
\usage{
glossa_analysis(
  pa_data = NULL,
  fit_layers = NULL,
  proj_files = NULL,
  study_area_poly = NULL,
  predictor_variables = NULL,
  thinning_method = NULL,
  thinning_value = NULL,
  scale_layers = FALSE,
  buffer = NULL,
  native_range = NULL,
  suitable_habitat = NULL,
  other_analysis = NULL,
  model_args = list(),
  cv_methods = NULL,
  cv_folds = 5,
  cv_block_source = "residuals_autocorrelation",
  cv_block_size = NULL,
  pseudoabsence_method = "random",
  pa_ratio = 1,
  target_group_points = NULL,
  pa_buffer_distance = NULL,
  seed = NA,
  waiter = NULL
)
}
\arguments{
\item{pa_data}{A list of data frames containing presence-absence data including `decimalLongitude`, `decimalLatitude`, `timestamp`, and `pa` columns.}

\item{fit_layers}{A ZIP file with the raster files containing model fitting environmental layers formatted as explained in the website documentation.}

\item{proj_files}{A list of ZIP file paths containing environmental layers for projection scenarios.}

\item{study_area_poly}{A spatial polygon defining the study area.}

\item{predictor_variables}{A list of the predictor variables to be used in the analysis for each occurrence dataset.}

\item{thinning_method}{A character specifying the spatial thinning method to apply to occurrence data. Options are `c("none", "distance", "grid", "precision")`. See `GeoThinneR` package for details.}

\item{thinning_value}{A numeric value used for thinning depending on the selected method: distance in meters (`distance`), grid resolution in degrees (`grid`), or decimal precision (`precision`).}

\item{scale_layers}{Logical; if `TRUE`, covariate layers will be standardize (z-score) based on fit layers.}

\item{buffer}{Buffer value or distance in decimal degrees (arc_degrees) for buffering the study area polygon.}

\item{native_range}{A vector of scenarios `c('fit_layers', 'projections')` where native range modeling should be performed.}

\item{suitable_habitat}{A vector of scenarios `c('fit_layers', 'projections')` where habitat suitability modeling should be performed.}

\item{other_analysis}{A vector of additional analyses to perform (e.g., `'variable_importance', 'functional_responses', 'cross_validation'`).}

\item{model_args}{A named list of additional arguments passed to the modeling function (e.g., `dbarts::bart`). This allows users to fine-tune model parameters such as `ntree` or `k`. These are passed internally via `...` and must match the arguments of the selected model function.}

\item{cv_methods}{A vector of the cross-validation strategies to perform. One or multiple of `"k-fold"`, `"spatial_blocks"`, `"temporal_blocks"`.}

\item{cv_folds}{Integer indicating the number of folds to generate.}

\item{cv_block_source}{For spatial blocks, how to determine block size. One of: `"residuals_autocorrelation"`, `"predictors_autocorrelation"`, `"manual"`.}

\item{cv_block_size}{Numeric block size in meters (used if `cv_block_source = "manual"`).}

\item{pseudoabsence_method}{Method for generating pseudo-absences. One of "random", "target_group", or "buffer_out".}

\item{pa_ratio}{Ratio of pseudo-absences to presences (pseudo-absence:presences).}

\item{target_group_points}{Optional data frame for sampling points for target-group method.}

\item{pa_buffer_distance}{Numeric buffer radius in degrees around each presence. Default is NULL.}

\item{seed}{Optional; an integer seed for reproducibility of results.}

\item{waiter}{Optional; a waiter instance to update progress in a Shiny application.}
}
\value{
A list containing structured outputs from each major section of the analysis, including model data, projections,
variable importance scores, and habitat suitability assessments.
}
\description{
This function wraps all the analysis that the GLOSSA package performs. It processes presence-absence data,
environmental covariates, and performs species distribution modeling and projections under past and future scenarios.
}
