% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{residuals_linpred_plot}
\alias{residuals_linpred_plot}
\title{Plot of residuals versus linear predictor values}
\usage{
residuals_linpred_plot(
  model,
  type = c("deviance", "pearson", "response", "pit", "quantile"),
  ylab = NULL,
  xlab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  point_col = "black",
  point_alpha = 1,
  line_col = "red",
  seed = NULL
)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{type}{character; type of residuals to use. One of \code{"deviance"},
\code{"response"}, \code{"pearson"}, \code{"pit"}, and \code{"quantile"} residuals are
allowed. \code{"pit"} uses probability integral transform (PIT) residuals,
which, if the model is correct should be approximately uniformly
distributed, while \code{"quantile"} transforms the PIT residuals through
application of the inverse CDF of the standard normal, and therefore the
quantile residuals should be approximately normally distributed (mean = 0,
sd = 1) if the model is correct. PIT and quantile residuals are not yet
available for most families that can be handled by \code{gam()}, but most
standard families are supported, e.g. those used by \code{glm()}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{xlab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{point_col}{colour used to draw points in the plots. See
\code{\link[graphics:par]{graphics::par()}} section \strong{Color Specification}. This is passed to
the individual plotting functions, and therefore affects the points of
all plots.}

\item{point_alpha}{numeric; alpha transparency for points in plots.}

\item{line_col}{colour specification for 1:1 line.}

\item{seed}{integer; random seed to use for PIT or quantile residuals.}
}
\description{
Plot of residuals versus linear predictor values
}
