% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_osm_data.R
\name{get_osm_data}
\alias{get_osm_data}
\title{Download OSM Data (Interactive Use Only)}
\usage{
get_osm_data(
  bbox,
  server_url = "https://nominatim.openstreetmap.org/search",
  username = NULL,
  password = NULL
)
}
\arguments{
\item{bbox}{Either a string representing the location (e.g., "Lausanne, Switzerland") or
a numeric vector of length 4 representing the bounding box coordinates
in the order: c(left, bottom, right, top).}

\item{server_url}{Optional string representing an alternative Nominatim server URL.}

\item{username}{Optional string for username if authentication is required for the server.}

\item{password}{Optional string for password if authentication is required for the server.}
}
\value{
A list containing:
\item{highways}{An sf object with the OSM data about highways in the specified location.}
\item{green_areas}{A list with an sf object of green area polygons.}
\item{trees}{An sf object with the OSM data about trees in the specified location.}
}
\description{
Downloads OpenStreetMap (OSM) data for a specified location or bounding box.
Includes highways, green areas, and trees for the specified location.
}
\details{
\strong{Note:} This function requires an internet connection and must be run interactively.
It performs HTTP requests to external APIs (Nominatim and Overpass via \code{osmdata}).
On CRAN and in non-interactive sessions, this function will error.
}
\examples{
\dontrun{
  # Using a location name
  osm_data <- get_osm_data("Lausanne, Switzerland")

  # Using coordinates for a bounding box
  bbox_coords <- c(6.6, 46.5, 6.7, 46.6)  # Example coordinates near Lausanne
  osm_data <- get_osm_data(bbox_coords)
}
}
