% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{weibull_censored}
\alias{weibull_censored}
\title{Weibull Censored Distribution}
\usage{
weibull_censored(
  shape,
  scale,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{shape}{Shape parameter of the Weibull distribution.}

\item{scale}{Scale parameter of the Weibull distribution.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{shape}).}
}
\value{
A greta censored Weibull distribution node.
}
\description{
Creates a censored Weibull distribution for use with greta.
}
