% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_greta_deps.R, R/reinstallers.R
\name{install_greta_deps}
\alias{install_greta_deps}
\alias{reinstall_greta_deps}
\title{Install Python dependencies for greta}
\usage{
install_greta_deps(
  deps = greta_deps_spec(),
  timeout = 5,
  restart = c("ask", "force", "no"),
  ...
)

reinstall_greta_deps(
  deps = greta_deps_spec(),
  timeout = 5,
  restart = c("ask", "force", "no")
)
}
\arguments{
\item{deps}{object created with \code{\link[=greta_deps_spec]{greta_deps_spec()}} where you
specify python, TF, and TFP versions. By default these are TF 2.15.0,
TFP 0.23.0, and Python 3.10. These versions must be compatible
with each other. If they are not, \code{\link[=greta_deps_spec]{greta_deps_spec()}} will error with
more information and suggestions. See ?\code{\link[=greta_deps_spec]{greta_deps_spec()}} for more
information, and see the data object \code{greta_deps_tf_tfp}
(`?greta_deps_tf_tfp``).}

\item{timeout}{maximum time in minutes until the installation for each
installation component times out and exits. Default is 5 minutes per
installation component.}

\item{restart}{character. Restart R after installation? Default is "ask".
Other options are, "force", and "no". Using "force" will will force a
restart after installation. Using  "no" will not restart. Note that this
only restarts R during interactive sessions, and only in RStudio.}

\item{...}{Optional arguments, reserved for future expansion.}
}
\description{
This is a helper function to install Python dependencies needed. By default
these are TF 2.15.0, TFP 0.23.0, and Python 3.10. These Python modules
will be installed into a conda environment named "greta-env-tf2".
}
\details{
You can specify an environment variable to write a logfile to a specific
location with \code{GRETA_INSTALLATION_LOG} using
\code{Sys.setenv('GRETA_INSTALLATION_LOG'='path/to/logfile.html')}. Or use
\code{\link[=greta_set_install_logfile]{greta_set_install_logfile()}} to set the path, e.g.,
\code{greta_set_install_logfile('path/to/logfile.html')}. By default it uses
\code{tools::R_user_dir("greta")} as the directory to save a logfile named
"greta-installation-logfile.html". To see installation notes or errors,
after installation you can open the logfile with
\code{\link[=open_greta_install_log]{open_greta_install_log()}}, or you can navigate to the logfile and open
it in a browser.

By default, if using RStudio, it will now ask you if you want to restart
the R session. If the session is not interactive, or is not in RStudio,
it will not restart. You can also override this with \code{restart = TRUE}.
}
\note{
This will automatically install Miniconda (a minimal version of the
Anaconda scientific software management system), create a 'conda'
environment for greta named 'greta-env-tf2' with required python and python
package versions, and forcibly switch over to using that conda environment.

If you don't want to use conda or the "greta-env-tf2" conda environment, you
can install versions that you like, e.g., using \code{\link[reticulate:py_install]{reticulate::py_install()}}.
If you want to see which versions of TF, TFP, and Python work with each
other (at least according to information from tensorflows website), see the
data \code{greta_deps_tf_tfp}, which is provided with greta. Managing your own
installation is not always straightforward, so we recommend installing
the python packages using \code{install_greta_deps()} for most users.
}
\examples{
\dontrun{
install_greta_deps()
}
\dontrun{
# to help troubleshoot your greta installation, this can help resolve some
# issues with installing greta dependencies
reinstall_greta_deps()
}
}
