% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_forest.R
\name{tune_forest}
\alias{tune_forest}
\title{Tune a forest}
\usage{
tune_forest(
  data,
  nrow.X,
  ncol.X,
  args,
  tune.parameters,
  tune.parameters.defaults,
  tune.num.trees,
  tune.num.reps,
  tune.num.draws,
  train
)
}
\arguments{
\item{data}{The data arguments (output from create_train_matrices) for the forest.}

\item{nrow.X}{The number of observations.}

\item{ncol.X}{The number of variables.}

\item{args}{The remaining call arguments for the forest.}

\item{tune.parameters}{The vector of parameter names to tune.}

\item{tune.parameters.defaults}{The grf default values for the vector of parameter names to tune.}

\item{tune.num.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{tune.num.reps}{The number of forests used to fit the tuning model.}

\item{tune.num.draws}{The number of random parameter values considered when using the model
to select the optimal parameters.}

\item{train}{The grf forest training function.}
}
\value{
tuning output
}
\description{
Finds the optimal parameters to be used in training a forest.
}
\keyword{internal}
