% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_wide_summary.R
\name{tbl_wide_summary}
\alias{tbl_wide_summary}
\title{Wide summary table}
\usage{
tbl_wide_summary(
  data,
  label = NULL,
  statistic = switch(type[[1]], continuous = c("{median}", "{p25}, {p75}"), c("{n}",
    "{p}\%")),
  digits = NULL,
  type = NULL,
  value = NULL,
  sort = all_categorical(FALSE) ~ "alphanumeric",
  include = everything()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{statistic}{(\code{character})\cr
character vector of the statistics to present. Each element of the vector
will result in a column in the summary table. Default is
\code{c("{median}", "{p25}, {p75}")} for continuous summaries, and
\code{c("{n}", "{p}\%")} for categorical/dichotomous summaries}

\item{digits}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}. See below for details.}

\item{type}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the summary type. Accepted value are
\code{c("continuous", "continuous2", "categorical", "dichotomous")}.
If not specified, default type is assigned via
\code{assign_summary_type()}. See below for details.}

\item{value}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the level of a variable to display on a single row.
The gtsummary type selectors, e.g. \code{all_dichotomous()}, cannot be used
with this argument. Default is \code{NULL}. See below for details.}

\item{sort}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies sorting to perform for categorical variables.
Values must be one of \code{c("alphanumeric", "frequency")}.
Default is \code{all_categorical(FALSE) ~ "alphanumeric"}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}
}
\value{
a gtsummary table of class 'tbl_wide_summary'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
This function is similar to \code{tbl_summary()}, but places summary statistics
wide, in separate columns.
All included variables must be of the same summary type, e.g. all continuous
summaries or all categorical summaries (which encompasses dichotomous variables).
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
trial |>
  tbl_wide_summary(include = c(response, grade))

trial |>
  tbl_strata(
    strata = trt,
    ~tbl_wide_summary(.x, include = c(age, marker))
  )
\dontshow{\}) # examplesIf}
}
