% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtstm.R
\name{create_CohortDtstmTrans}
\alias{create_CohortDtstmTrans}
\alias{create_CohortDtstmTrans.multinom_list}
\alias{create_CohortDtstmTrans.msm}
\alias{create_CohortDtstmTrans.params_mlogit_list}
\title{Create \code{CohortDtstmTrans} object}
\usage{
create_CohortDtstmTrans(object, ...)

\method{create_CohortDtstmTrans}{multinom_list}(
  object,
  input_data,
  trans_mat,
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_CohortDtstmTrans}{msm}(
  object,
  input_data,
  cycle_length,
  n = 1000,
  uncertainty = c("normal", "none"),
  ...
)

\method{create_CohortDtstmTrans}{params_mlogit_list}(object, input_data, trans_mat, ...)
}
\arguments{
\item{object}{An object of the appropriate class containing either a
fitted statistical model or model parameters.}

\item{...}{Further arguments passed to \code{CohortDtstmTrans$new()} in
\code{\link{CohortDtstmTrans}}.}

\item{input_data}{An object of class \code{expanded_hesim_data} returned by
\code{\link[=expand.hesim_data]{expand.hesim_data()}}}

\item{trans_mat}{A transition matrix describing the states and transitions
in a discrete-time multi-state model. See \code{\link{CohortDtstmTrans}}.}

\item{n}{Number of random observations to draw. Not used if \code{uncertainty = "none"}.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled.
If \code{"normal"}, then parameters are randomly drawn from their multivariate normal
distribution. If \code{"none"}, then only point estimates are returned.}

\item{cycle_length}{The length of a model cycle in terms of years. The default
is 1 meaning that model cycles are 1 year long.}
}
\description{
A generic function for creating an object of class \code{\link{CohortDtstmTrans}}.
}
\details{
Disease models may either be created from a fitted statistical
model or from a parameter object. In the case of the former, \code{input_data}
is a data frame like object that is used to look for variables from
the statistical model that are required for simulation. In this sense,
\code{input_data} is very similar to the \code{newdata} argument in most \code{\link[=predict]{predict()}}
methods (e.g., see \code{\link[=predict.lm]{predict.lm()}}). In other words, variables used in the
\code{\link{formula}} of the statistical model must also be in \code{input_data}.

In the case of the latter, the columns of \code{input_data} must be named in a
manner that is consistent with the parameter object. In the typical case
(e.g., with \code{\link{params_surv}} or \code{\link{params_mlogit}}), the parameter object
contains coefficients from a regression model, usually stored as matrix
where rows index parameter samples (i.e., for a probabilistic sensitivity
analysis) and columns index model terms. In such instances, there must
be one column from \code{input_data} with the same name as each model term in the
coefficient matrix; that is, the columns in \code{input_data} are matched with
the columns of the coefficient matrices by name. If there are model terms
in the coefficient matrices that are not contained in \code{input_data}, then
an error will be thrown.
}
\seealso{
See \code{\link{CohortDtstmTrans}} for examples.
}
