% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_icosa_tri_to_quad_ij}
\alias{hexify_icosa_tri_to_quad_ij}
\title{Convert Icosa Triangle to Quad IJ coordinates}
\usage{
hexify_icosa_tri_to_quad_ij(
  icosa_triangle_face,
  icosa_triangle_x,
  icosa_triangle_y,
  resolution,
  aperture = 3L
)
}
\arguments{
\item{icosa_triangle_face}{Triangle face number (0-19)}

\item{icosa_triangle_x}{X coordinate on triangle face}

\item{icosa_triangle_y}{Y coordinate on triangle face}

\item{resolution}{Grid resolution level}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
List with components:
\item{quad}{Quad number (0-11)}
\item{i}{Integer cell index along first axis}
\item{j}{Integer cell index along second axis}
}
\description{
Converts icosahedral triangle coordinates directly to Quad IJ,
combining the transformation and quantization steps.
}
\examples{
# First get triangle coordinates from lon/lat
fwd <- hexify_forward(lon = 2.35, lat = 48.86)

# Then convert to quad IJ
quad_ij <- hexify_icosa_tri_to_quad_ij(
  icosa_triangle_face = fwd["face"],
  icosa_triangle_x = fwd["icosa_triangle_x"],
  icosa_triangle_y = fwd["icosa_triangle_y"],
  resolution = 10,
  aperture = 3
)
print(quad_ij)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
