% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetero.R
\name{spatial_hetero_test}
\alias{spatial_hetero_test}
\alias{spatial_hetero_test.default}
\alias{spatial_hetero_test.matrix}
\alias{spatial_hetero_test.numeric}
\alias{spatial_hetero_test.vector}
\alias{spatial_hetero_test.data.frame}
\alias{spatial_hetero_test.sf}
\title{Generic method to test spatial heterogeneity}
\usage{
spatial_hetero_test(x, ...)

\method{spatial_hetero_test}{default}(x, ...)

\method{spatial_hetero_test}{matrix}(x, coords, ...)

\method{spatial_hetero_test}{numeric}(x, coords, ...)

\method{spatial_hetero_test}{vector}(x, coords, ...)

\method{spatial_hetero_test}{data.frame}(x, coords, ...)

\method{spatial_hetero_test}{sf}(x, ...)
}
\arguments{
\item{x}{The data to be tested.}

\item{...}{
  Arguments passed on to \code{\link[=spatial_hetero_test_data]{spatial_hetero_test_data}}, \code{\link[=spatial_hetero_test_data]{spatial_hetero_test_data}}
  \describe{
    \item{\code{resample}}{The total times of resampling with replacement.
Default to 5000.}
    \item{\code{poly}}{The number of polynomial terms used by the polynomial estimator.
Default to 2.}
    \item{\code{bw}}{The adaptive bandwidth used by the polynomial estimator.
Default to 10.}
    \item{\code{kernel}}{The kernel function used by the polynomial estimator.}
    \item{\code{verbose}}{The verbosity level. Default to 0.}
  }}

\item{coords}{The coordinates used for testing.
Accepts a matrix or vector.
For matrix, it needs to have the same number of rows as \code{x}.
For vector, it indicates the columns in \code{x}
and the actual coordinates will be taken from \code{x}.}
}
\description{
Generic method to test spatial heterogeneity
}
\section{Methods (by class)}{
\itemize{
\item \code{spatial_hetero_test(default)}: Default behavior.

\item \code{spatial_hetero_test(matrix)}: For the matrix, \code{coords} is necessary.

\item \code{spatial_hetero_test(numeric)}: Takes \code{x} as values of a series variables stored by column,
and \code{coords} as coordinates for each row in \code{x}.

\item \code{spatial_hetero_test(vector)}: Takes \code{x} as values of the variable,
and \code{coords} as coordinates for each element in \code{x}.

\item \code{spatial_hetero_test(data.frame)}: Takes \code{x} as variable values (each column is a variable),
and \code{coords} as coordinates for each row in \code{x}.

\item \code{spatial_hetero_test(sf)}: For the \code{sf} object, coordinates of centroids are used.
Only the numerical columns are tested.

}}
