% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fup.R
\name{get_fup}
\alias{get_fup}
\title{Retrieve and parse fraction unbound in plasma}
\usage{
get_fup(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  force.human.fup = FALSE,
  suppress.messages = FALSE,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing fraction of unbound plasma with
human values if true.}

\item{force.human.fup}{If a non-human species value (matching argument
species) is available, it is ignored and the human fraction unbound is
returned}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{\ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}}
is not allowed to drop below this value (default is 0.0001).}
}
\value{
list containing:
\item{Funbound.plasma.point}{Point estimate (central tendency) of the Unbound fraction in plasma}
\item{Funbound.plasma.dist}{Quantiles of a distribution (median, lower and upper 95th percentiles) for the unbound fraction}
}
\description{
This function retrieves the chemical- and species-specific fraction
unbound in plasma (\ifelse{html}{\out{f<sub>up</sub>}}{\eqn{f_{up}}}) 
from \code{\link{chem.physical_and_invitro.data}}. 
If that parameter is described by a distribution (that is, a median, 
lower-, and upper-95th percentile separated by commas) this 
function splits those quantiles into separate values.
}
\seealso{
\code{\link{chem.physical_and_invitro.data}}
}
\author{
John Wambaugh
}
\keyword{Parameter}
\keyword{in-vitro}
