% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastplot.R
\name{summary.inz_frct}
\alias{summary.inz_frct}
\alias{print.summary_inz_frct}
\title{Summarise iNZightTS forecasts}
\usage{
\method{summary}{inz_frct}(object, var = NULL, ...)

\method{print}{summary_inz_frct}(x, show_details = FALSE, ...)
}
\arguments{
\item{object}{An \code{inz_frct} object representing the forecasts.}

\item{var}{A character vector specifying the variable to summarize,
or set to \code{NULL} to summarize all variables.}

\item{...}{Additional arguments (ignored).}

\item{x}{A `summary_inz_frct` object containing forecast summaries.}

\item{show_details}{Logical; set to `TRUE` to show model details only when
`pred_model` is an "ARIMA" model.}
}
\value{
A \code{summary_inz_frct} object containing the first few forecast
observations, the forecasting model used, and its details (such as
call, coefficients, and goodness of fit statistics).
}
\description{
Summary method for objects of class \code{inz_frct}.
}
\examples{
ts <- inzightts(visitorsQ, var = 2:5)
p <- predict(ts, "Japan")
s <- summary(p, "Japan")
s
print(s, show_details = TRUE)

}
\seealso{
\code{\link[iNZightTS]{predict.inz_ts}}
}
