% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{rank_vars}
\alias{rank_vars}
\title{Rank the data of numeric variables}
\usage{
rank_vars(data, vars, rank_type = c("min", "dense", "percent"))
}
\arguments{
\item{data}{a dataframe with the variables to rank}

\item{vars}{a character vector of numeric variables in \code{data}
to rank}

\item{rank_type}{either \code{"min"}, \code{"dense"} or \code{"percent"},
see \code{\link[dplyr]{row_number}}, \code{\link[dplyr]{percent_rank}}}
}
\value{
the original dataframe containing new columns with the ranks of the
        variables in \code{vars} with tidyverse code attached
}
\description{
Rank the values of numeric variables, for example, in descending order,
and then returns the result along with tidyverse code used to generate it.
See \code{\link[dplyr]{row_number}} and \code{\link[dplyr]{percent_rank}}.
}
\examples{
ranked <- rank_vars(iris, vars = c("Sepal.Length", "Petal.Length"))
cat(code(ranked))
head(ranked)

}
\seealso{
\code{\link{code}}
}
\author{
Zhaoming Su
}
