% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cran_history}
\alias{cran_history}
\title{History of the Number of Available CRAN Packages}
\format{
A data frame with 70 rows and
4 variables.
\describe{
\item{date}{date}
\item{n_packages}{the number of available R packages on CRAN}
\item{version}{the then current version of R}
\item{source}{source of the data (see 'Details')}
}
}
\usage{
cran_history
}
\description{
Table with the number of packages available on CRAN and the current R version
for historic dates back to 21 June 2001.
}
\details{
Data on the number of packages on CRAN between 2001-06-21 and 2014-04-13
is obtained from
\href{https://www.rdocumentation.org/packages/Ecdat/versions/0.3-9/topics/CRANpackages}{\code{CRANpackages}}
from the package \href{https://cran.r-project.org/package=Ecdat}{\code{Ecdat}}.
This data was collected by John Fox and Spencer Graves.
Intervals between data points are irregularly spaced. These data are
marked with "John Fox" or "Spencer Graves" in the column \code{source}.
They are licenced under GPL-2/GPL-3.

Data between 2014-10-01 and 2023-03-06 was collected by the package author
from CRAN snapshots on Microsoft's MRAN, which was retired on 1 July 2023.
Data was collected on the first day of each quarter.
These data are marked with "MRAN" in the column \code{source}.

Newer data has been collected in irregular intervals using the functions
\code{\link[=n_available_packages]{n_available_packages()}} and \code{\link[=available_r_version]{available_r_version()}}.
These data are marked with "CRAN" in the column \code{source}.
}
\examples{
library(ggplot2)
ggplot(cran_history, aes(x = date, y = n_packages)) +
  geom_point()

}
\keyword{datasets}
