% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_catalog.R
\name{create_catalog}
\alias{create_catalog}
\title{Function to create a catalog of level 0 files to be merged.}
\usage{
create_catalog(
  file,
  sheet,
  skip.rows,
  date,
  compound,
  istd,
  col.names.loc,
  sample,
  type,
  peak,
  istd.peak,
  conc,
  analysis.param,
  num.rows = NULL,
  additional.info = NULL,
  verbose = TRUE
)
}
\arguments{
\item{file}{(\emph{character vector}) Vector of character strings with
the file names of level 0 data.}

\item{sheet}{(\emph{character vector}) Vector of character strings containing
the sheet name with MS data.}

\item{skip.rows}{(\emph{numeric vector}) Numeric vector containing the
number of rows to skip in data file.}

\item{date}{(\emph{character vector}) Vector of character strings containing
the date of data collection, format "MMDDYY".
"MM" = 2 digit month, "DD" = 2 digit day, and "YY" = 2 digit year.}

\item{compound}{(\emph{character vector}) Vector of character strings with
the relevant chemical identifier.}

\item{istd}{(\emph{character vector}) Vector of character strings with the
internal standard.}

\item{col.names.loc}{(\emph{numeric vector}) Numeric vector containing the 
row locations of the column names.}

\item{sample}{(\emph{character vector}) Vector of character strings with
column names containing samples.}

\item{type}{(\emph{character vector}) Vector of character strings with column
names containing type information.}

\item{peak}{(\emph{character vector}) Vector of character strings with the
column names containing mass spectrometry (MS) peak data.}

\item{istd.peak}{(\emph{character vector}) Vector of character strings with
column names containing internal standard (ITSD) peak data.}

\item{conc}{(\emph{character vector}) Vector of character strings with column
names containing exposure concentration data.}

\item{analysis.param}{(\emph{character vector}) Vector of character strings
with column names containing analysis parameters.}

\item{num.rows}{(\emph{numeric vector}) Numeric vector containing the number
of rows with data to be pulled. (Default is \code{NULL}.)}

\item{additional.info}{(\emph{list} or \emph{data.frame}) Named list or
data.frame of additional columns to
include in the catalog. Additional columns should
follow the nomenclature of "<Fill-in>.ColName" if
indicating column names with information to pull,
otherwise a short name.  All spaces in additional
column names should be designated with a period, "." .
(Default is \code{NULL}, i.e. no additional columns.)}

\item{verbose}{(\emph{logical}) Indicate whether printed statements should be shown.
(Default is TRUE.)}
}
\value{
(\emph{data.frame}) A catalog containing information about the source
        level-0 data file to enable proper 'auto-extraction' of data.
        Additionally, the catalog contains other relevant meta-data fields
        describing when, how, what, etc. of the assay that collected the
        level-0 data.
}
\description{
This function is meant for creating a catalog of all level 0 data
files listed that will be merged with the `merge_level0` function.
All arguments are required, with exception of `additional.info`.
}
\examples{
create_catalog(
  file = "testME.xlsx",sheet = "3",skip.rows = 0,
  date = "112723",compound = "80-05-7",
  istd = "Chemical A", col.names.loc = 1, 
  sample = "Sample.Name",type = "Type",
  peak = "Response.Area",istd.peak = "ISTD.Peak.Area",
  conc = "Intended.Concentration",analysis.param = "A,B,C"
)

}
\seealso{
merge_level0
}
