
# This file is automatically generated, you probably don't want to edit this

anovaOneWOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "anovaOneWOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            deps = NULL,
            group = NULL,
            welchs = TRUE,
            fishers = FALSE,
            miss = "perAnalysis",
            desc = FALSE,
            descPlot = FALSE,
            norm = FALSE,
            qq = FALSE,
            eqv = FALSE,
            phMethod = "none",
            phMeanDif = TRUE,
            phSig = TRUE,
            phTest = FALSE,
            phFlag = FALSE, ...) {

            super$initialize(
                package="jmv",
                name="anovaOneW",
                requiresData=TRUE,
                ...)

            private$..deps <- jmvcore::OptionVariables$new(
                "deps",
                deps,
                required=TRUE,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                required=TRUE,
                rejectUnusedLevels=TRUE,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"))
            private$..welchs <- jmvcore::OptionBool$new(
                "welchs",
                welchs,
                default=TRUE)
            private$..fishers <- jmvcore::OptionBool$new(
                "fishers",
                fishers,
                default=FALSE)
            private$..miss <- jmvcore::OptionList$new(
                "miss",
                miss,
                options=list(
                    "perAnalysis",
                    "listwise"),
                default="perAnalysis")
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..descPlot <- jmvcore::OptionBool$new(
                "descPlot",
                descPlot,
                default=FALSE)
            private$..norm <- jmvcore::OptionBool$new(
                "norm",
                norm,
                default=FALSE)
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..eqv <- jmvcore::OptionBool$new(
                "eqv",
                eqv,
                default=FALSE)
            private$..phMethod <- jmvcore::OptionList$new(
                "phMethod",
                phMethod,
                options=list(
                    "none",
                    "gamesHowell",
                    "tukey"),
                default="none")
            private$..phMeanDif <- jmvcore::OptionBool$new(
                "phMeanDif",
                phMeanDif,
                default=TRUE)
            private$..phSig <- jmvcore::OptionBool$new(
                "phSig",
                phSig,
                default=TRUE)
            private$..phTest <- jmvcore::OptionBool$new(
                "phTest",
                phTest,
                default=FALSE)
            private$..phFlag <- jmvcore::OptionBool$new(
                "phFlag",
                phFlag,
                default=FALSE)

            self$.addOption(private$..deps)
            self$.addOption(private$..group)
            self$.addOption(private$..welchs)
            self$.addOption(private$..fishers)
            self$.addOption(private$..miss)
            self$.addOption(private$..desc)
            self$.addOption(private$..descPlot)
            self$.addOption(private$..norm)
            self$.addOption(private$..qq)
            self$.addOption(private$..eqv)
            self$.addOption(private$..phMethod)
            self$.addOption(private$..phMeanDif)
            self$.addOption(private$..phSig)
            self$.addOption(private$..phTest)
            self$.addOption(private$..phFlag)
        }),
    active = list(
        deps = function() private$..deps$value,
        group = function() private$..group$value,
        welchs = function() private$..welchs$value,
        fishers = function() private$..fishers$value,
        miss = function() private$..miss$value,
        desc = function() private$..desc$value,
        descPlot = function() private$..descPlot$value,
        norm = function() private$..norm$value,
        qq = function() private$..qq$value,
        eqv = function() private$..eqv$value,
        phMethod = function() private$..phMethod$value,
        phMeanDif = function() private$..phMeanDif$value,
        phSig = function() private$..phSig$value,
        phTest = function() private$..phTest$value,
        phFlag = function() private$..phFlag$value),
    private = list(
        ..deps = NA,
        ..group = NA,
        ..welchs = NA,
        ..fishers = NA,
        ..miss = NA,
        ..desc = NA,
        ..descPlot = NA,
        ..norm = NA,
        ..qq = NA,
        ..eqv = NA,
        ..phMethod = NA,
        ..phMeanDif = NA,
        ..phSig = NA,
        ..phTest = NA,
        ..phFlag = NA)
)

anovaOneWResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "anovaOneWResults",
    inherit = jmvcore::Group,
    active = list(
        anova = function() private$.items[["anova"]],
        desc = function() private$.items[["desc"]],
        assump = function() private$.items[["assump"]],
        plots = function() private$.items[["plots"]],
        postHoc = function() private$.items[["postHoc"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="One-Way ANOVA")
            self$add(jmvcore::Table$new(
                options=options,
                name="anova",
                title="One-Way ANOVA",
                rows="(deps)",
                visible="(fishers || welchs)",
                clearWith=list(
                    "group",
                    "miss"),
                columns=list(
                    list(
                        `name`="dep", 
                        `title`="", 
                        `content`="($key)", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="test[welch]", 
                        `title`="", 
                        `content`="Welch's", 
                        `type`="text", 
                        `visible`="(fishers && welchs)"),
                    list(
                        `name`="test[fisher]", 
                        `title`="", 
                        `content`="Fisher's", 
                        `type`="text", 
                        `visible`="(fishers && welchs)"),
                    list(
                        `name`="F[welch]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(welchs)"),
                    list(
                        `name`="F[fisher]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(fishers)"),
                    list(
                        `name`="df1[welch]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(welchs)"),
                    list(
                        `name`="df1[fisher]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(fishers)"),
                    list(
                        `name`="df2[welch]", 
                        `title`="df2", 
                        `type`="number", 
                        `visible`="(welchs)"),
                    list(
                        `name`="df2[fisher]", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(fishers)"),
                    list(
                        `name`="p[welch]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(welchs)"),
                    list(
                        `name`="p[fisher]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(fishers)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Group Descriptives",
                rows=0,
                visible="(desc)",
                clearWith=list(
                    "group",
                    "miss"),
                columns=list(
                    list(
                        `name`="dep", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="group", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="num", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="mean", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="sd", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    norm = function() private$.items[["norm"]],
                    eqv = function() private$.items[["eqv"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumption Checks")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="norm",
                            title="Normality Test (Shapiro-Wilk)",
                            visible="(norm)",
                            rows="(deps)",
                            clearWith=list(
                                "miss",
                                "group"),
                            notes=list(
                                `p`="A low p-value suggests a violation of the assumption of normality"),
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `content`="($key)", 
                                    `type`="text"),
                                list(
                                    `name`="w", 
                                    `title`="W", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="eqv",
                            title="Homogeneity of Variances Test (Levene's)",
                            refs="car",
                            visible="(eqv)",
                            rows="(deps)",
                            columns=list(
                                list(
                                    `name`="dep", 
                                    `title`="", 
                                    `content`="($key)", 
                                    `type`="text"),
                                list(
                                    `name`="F", 
                                    `type`="number"),
                                list(
                                    `name`="df1", 
                                    `type`="integer"),
                                list(
                                    `name`="df2", 
                                    `type`="integer"),
                                list(
                                    `name`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))}))$new(options=options))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(deps)",
                clearWith=list(
                    "group",
                    "miss"),
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(
                        desc = function() private$.items[["desc"]],
                        qq = function() private$.items[["qq"]]),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="$key")
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="desc",
                                height=350,
                                visible="(descPlot)",
                                renderFun=".desc",
                                clearWith=list()))
                            self$add(jmvcore::Image$new(
                                options=options,
                                name="qq",
                                width=350,
                                height=300,
                                requiresData=TRUE,
                                visible="(qq)",
                                renderFun=".qq",
                                clearWith=list()))}))$new(options=options)))
            self$add(jmvcore::Array$new(
                options=options,
                name="postHoc",
                title="Post Hoc Tests",
                items="(deps)",
                visible="(phMethod:gamesHowell || phMethod:tukey)",
                template=jmvcore::Table$new(
                    options=options,
                    title="Post Hoc Tests \u2013 $key",
                    rows="(levels(group))",
                    clearWith=list(
                        "group",
                        "miss",
                        "phMethod",
                        "phFlag"),
                    columns=list(
                        list(
                            `name`=".name[md]", 
                            `title`="", 
                            `type`="text", 
                            `content`="($key)", 
                            `combineBelow`=TRUE, 
                            `visible`="(phMeanDif)"),
                        list(
                            `name`=".stat[md]", 
                            `title`="", 
                            `type`="text", 
                            `content`="Mean difference", 
                            `visible`="(phMeanDif)"),
                        list(
                            `name`=".name[t]", 
                            `title`="", 
                            `type`="text", 
                            `content`="($key)", 
                            `combineBelow`=TRUE, 
                            `visible`="(phTest)"),
                        list(
                            `name`=".stat[t]", 
                            `title`="", 
                            `type`="text", 
                            `content`="t-value", 
                            `visible`="(phTest)"),
                        list(
                            `name`=".name[df]", 
                            `title`="", 
                            `type`="text", 
                            `content`="($key)", 
                            `combineBelow`=TRUE, 
                            `visible`="(phTest)"),
                        list(
                            `name`=".stat[df]", 
                            `title`="", 
                            `type`="text", 
                            `content`="df", 
                            `visible`="(phTest)"),
                        list(
                            `name`=".name[p]", 
                            `title`="", 
                            `type`="text", 
                            `content`="($key)", 
                            `combineBelow`=TRUE, 
                            `visible`="(phSig)"),
                        list(
                            `name`=".stat[p]", 
                            `title`="", 
                            `type`="text", 
                            `content`="p-value", 
                            `visible`="(phSig)")))))}))

anovaOneWBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "anovaOneWBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "jmv",
                name = "anovaOneW",
                version = c(1,0,0),
                options = options,
                results = anovaOneWResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE,
                weightsSupport = 'auto')
        }))

#' One-Way ANOVA
#'
#' The Analysis of Variance (ANOVA) is used to explore the relationship
#' between a continuous dependent variable, and one or more categorical
#' explanatory variables. This 'One-Way ANOVA' is a simplified version of
#' the 'normal' ANOVA, allowing only a single explanatory factor, however
#' also providing a Welch's ANOVA. The Welch's ANOVA has the advantage that
#' it need not assume that the variances of all groups are equal.
#' 
#' For convenience, this method allows specifying multiple dependent
#' variables, resulting in multiple independent tests.
#' 
#' Note that the Welch's ANOVA is the same procedure as the Welch's
#' independent samples t-test.
#' 
#'
#' @examples
#' data('ToothGrowth')
#' dat <- ToothGrowth
#' dat$dose <- factor(dat$dose)
#'
#' anovaOneW(formula = len ~ dose, data = dat)
#'
#' #
#' #  ONE-WAY ANOVA
#' #
#' #  One-Way ANOVA (Welch's)
#' #  ----------------------------------------
#' #           F       df1    df2     p
#' #  ----------------------------------------
#' #    len    68.4      2    37.7    < .001
#' #  ----------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param deps a string naming the dependent variables in \code{data}
#' @param group a string naming the grouping or independent variable in
#'   \code{data}
#' @param welchs \code{TRUE} (default) or \code{FALSE}, perform Welch's
#'   one-way ANOVA which does not assume equal variances
#' @param fishers \code{TRUE} or \code{FALSE} (default), perform Fisher's
#'   one-way ANOVA which assumes equal variances
#' @param miss \code{'perAnalysis'} or \code{'listwise'}, how to handle
#'   missing values; \code{'perAnalysis'} excludes missing values for individual
#'   dependent variables, \code{'listwise'} excludes a row from all analyses if
#'   one of its entries is missing.
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param descPlot \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   plots
#' @param norm \code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
#'   test of normality
#' @param qq \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param eqv \code{TRUE} or \code{FALSE} (default), perform Levene's test for
#'   homogeneity of variances
#' @param phMethod \code{'none'}, \code{'gamesHowell'} or \code{'tukey'},
#'   which post-hoc tests to provide; \code{'none'} shows no post-hoc tests,
#'   \code{'gamesHowell'} shows Games-Howell post-hoc tests where no equivalence
#'   of variances is assumed, and \code{'tukey'} shows Tukey post-hoc tests
#'   where equivalence of variances is assumed
#' @param phMeanDif \code{TRUE} (default) or \code{FALSE}, provide mean
#'   differences for post-hoc tests
#' @param phSig \code{TRUE} (default) or \code{FALSE}, provide significance
#'   levels for post-hoc tests
#' @param phTest \code{TRUE} or \code{FALSE} (default), provide test results
#'   (t-value and degrees of freedom) for post-hoc tests
#' @param phFlag \code{TRUE} or \code{FALSE} (default), flag significant
#'   post-hoc comparisons
#' @param formula (optional) the formula to use, see the examples
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$anova} \tab \tab \tab \tab \tab a table of the test results \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table containing the group descriptives \cr
#'   \code{results$assump$norm} \tab \tab \tab \tab \tab a table containing the normality tests \cr
#'   \code{results$assump$eqv} \tab \tab \tab \tab \tab a table of homogeneity of variances tests \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of groups of plots \cr
#'   \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$anova$asDF}
#'
#' \code{as.data.frame(results$anova)}
#'
#' @export
anovaOneW <- function(
    data,
    deps,
    group,
    welchs = TRUE,
    fishers = FALSE,
    miss = "perAnalysis",
    desc = FALSE,
    descPlot = FALSE,
    norm = FALSE,
    qq = FALSE,
    eqv = FALSE,
    phMethod = "none",
    phMeanDif = TRUE,
    phSig = TRUE,
    phTest = FALSE,
    phFlag = FALSE,
    formula) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("anovaOneW requires jmvcore to be installed (restart may be required)")

    if ( ! missing(formula)) {
        if (missing(deps))
            deps <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from="lhs",
                required=TRUE)
        if (missing(group))
            group <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from="rhs")
    }

    if ( ! missing(deps)) deps <- jmvcore::resolveQuo(jmvcore::enquo(deps))
    if ( ! missing(group)) group <- jmvcore::resolveQuo(jmvcore::enquo(group))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(deps), deps, NULL),
            `if`( ! missing(group), group, NULL))

    for (v in group) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])

    options <- anovaOneWOptions$new(
        deps = deps,
        group = group,
        welchs = welchs,
        fishers = fishers,
        miss = miss,
        desc = desc,
        descPlot = descPlot,
        norm = norm,
        qq = qq,
        eqv = eqv,
        phMethod = phMethod,
        phMeanDif = phMeanDif,
        phSig = phSig,
        phTest = phTest,
        phFlag = phFlag)

    analysis <- anovaOneWClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

