% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kanji1.R
\name{convert_kanji}
\alias{convert_kanji}
\title{Convert between kanji formats}
\usage{
convert_kanji(
  key,
  output = c("all", "index", "character", "hexmode", "kanjivec"),
  simplify = TRUE
)
}
\arguments{
\item{key}{an atomic vector or list of kanji in any combination of formats.}

\item{output}{a string describing the desired output.}

\item{simplify}{logical. Whether to simplify the output to an atomic vector
or keep the structure of the original vector. In either case it depends on
output whether this is possible.}
}
\value{
A vector of the same length as key. If \code{simplify} is \code{TRUE}, this is an
atomic vector for output = "index", "character" or "hexmode", and a list
for output = "kanjivec" or "all" a list. If \code{simplify} is \code{FALSE}, the original
structure (atomic or list) kept whenever possible.
}
\description{
Accept any interpretable representation of kanji in terms of index numbers,
UTF-8 character strings of length 1, UTF-8 codepoints
or \code{\link{kanjivec}} objects and convert it to all or any of these
formats.
}
\details{
Index numbers are in terms of the order in \code{\link{kbase}}. UTF-8 codepoints are
usually of class "hexmode", but character strings starting
with "0x" or "0X" are also accepted in the \code{key}.

For \code{output = "kanjivec"}, the GitHub package kanjistat.data has to be available or
an error is returned. For \code{output = "all"}, component kanjivec is set to NA if
kanjistat.data is not available.
}
\examples{
convert_kanji(as.hexmode("99ac"))
convert_kanji("0x99ac")  # same
convert_kanji(500, "character") == kbase$kanji[500]  # TRUE
}
