% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{get_layer}
\alias{get_layer}
\title{Retrieves a layer based on either its name (unique) or index.}
\usage{
get_layer(object, name = NULL, index = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{name}{String, name of layer.}

\item{index}{Integer, index of layer (1-based). Also valid are negative
values, which count from the end of model.}
}
\value{
A layer instance.
}
\description{
Indices are based on order of horizontal graph traversal (bottom-up) and are
1-based. If \code{name} and \code{index} are both provided, \code{index} will take
precedence.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{keras_model}()},
\code{\link{keras_model_sequential}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
