% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_measures.R
\name{Acc}
\alias{Acc}
\title{Accuracy}
\usage{
Acc(ct, weighted = FALSE)
}
\arguments{
\item{ct}{Confusion Matrix.}

\item{weighted}{If TRUE, the weighted accuracy is returned. (Defaults: FALSE).}
}
\value{
Accuracy of the model (a single value).
}
\description{
`Acc()` computes the accuracy between the output
of a classification model and the actual values of the target.
It can also compute the weighted accuracy, which is useful in
imbalanced classification problems. The weighting is applied according
to the class frequencies in the target. In balanced problems, weighted Acc = Acc.
}
\examples{
y <- c(rep("a",3),rep("b",2))
y_pred <- c(rep("a",2),rep("b",3))
ct <- table(y,y_pred)
Acc(ct)
Acc(ct,weighted=TRUE)
}
