% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Chi2}
\alias{Chi2}
\title{Chi-squared kernel}
\usage{
Chi2(X, g = NULL)
}
\arguments{
\item{X}{Matrix or data.frame (dimension \emph{NxD}) that contains nonnegative numbers. Each row represents
the counts of words of \emph{N} documents, while each column is a word.}

\item{g}{Gamma hyperparameter. If g=0 or NULL, `Chi2()` returns the LeCam
distances between the documents instead of the \eqn{\chi^2} kernel matrix.
(Defaults=NULL).}
}
\value{
Kernel matrix (dimension: \emph{NxN}).
}
\description{
`Chi2()` computes the basic \eqn{\chi^2} kernel for bag-of-words (BoW) or bag-of-visual-words
data. This kernel computes the similarity between two nonnegative vectors that represent
the occurrence counts of words in two different documents.
}
\examples{
## Example dataset: word counts in 4 documents
documents <- matrix( c(0, 1, 3, 2, 1, 0,  1, 1, 6,4,3,1,3,5,6,2), nrow=4,byrow=TRUE)
rownames(documents) <- paste0("doc",1:4)
colnames(documents) <- c("animal","life","tree","ecosystem")
documents
Chi2(documents,g=NULL)
}
\references{
Zhang, Jianguo, et al. Local features and kernels for classification
of texture and object categories: A comprehensive study. International journal of computer
vision 73 (2007): 213-238. \href{https://inria.hal.science/inria-00548574/document}{Link}
}
