% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{ci_var}
\alias{ci_var}
\title{Confidence Intervals on Dataframe}
\usage{
ci_var(df, var, group_var = NULL, conf = 0.95)
}
\arguments{
\item{df}{Dataframe}

\item{var}{Variable name. Must be a numerical column.}

\item{group_var}{Variable name. Group results by another variable.}

\item{conf}{Numeric. Confidence level (0-1).}
}
\value{
data.frame mean, standard deviation, counter, upper and lower CIs.
}
\description{
Calculate confidence intervals for a continuous numerical column on
a dataframe, given a confidence level. You may also group results
using another variable. Tidyverse friendly.
}
\examples{
data(dft) # Titanic dataset
ci_var(dft, Fare)
ci_var(dft, Fare, Pclass)
ci_var(dft, Fare, Pclass, conf = 0.99)
}
\seealso{
Other Confidence: 
\code{\link{ci_lower}()}
}
\concept{Confidence}
