% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_metrics.R
\name{conf_mat}
\alias{conf_mat}
\title{Confussion Matrix}
\usage{
conf_mat(tag, score, thresh = 0.5, sense = ">=", diagonal = TRUE, plot = FALSE)
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}

\item{thresh}{Integer. Threshold for selecting binary or regression
models: this number is the threshold of unique values we should
have in \code{'tag'} (more than: regression; less than: classification)}

\item{sense}{Character. Inequation sense for threshold: <, <=, >=, >}

\item{diagonal}{Boolean. \code{FALSE} to convert diagonal numbers to
zeroes. Ideal to detect must confusing categories.}

\item{plot}{Boolean. Plot result? Uses \code{mplot_conf()}}
}
\value{
data.frame. Result of counting \code{tag} and \code{score}'s tag
given a \code{thresh}old, similar to \code{base::table()}.
}
\description{
This function calculates a Confussion Matrix using crosstab for
2 or more categories. You can either set the score and threshold
or the labels you wish to cross with.
}
\details{
You may use \code{mplot_conf()} or set \code{plot=TRUE}.
}
\examples{
data(dfr) # Results for AutoML Predictions
lapply(dfr[c(1, 2)], head)

# Results for Binomial Model
conf_mat(dfr$class2$tag, dfr$class2$scores)
conf_mat(dfr$class2$tag, dfr$class2$scores, thresh = 0.3)
conf_mat(dfr$class2$tag, dfr$class2$scores, sense = "<=")

# Results for Multi-Categorical Model
conf_mat(dfr$class3$tag, dfr$class3$score)
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Model metrics: 
\code{\link{ROC}()},
\code{\link{errors}()},
\code{\link{gain_lift}()},
\code{\link{loglossBinary}()},
\code{\link{model_metrics}()}
}
\concept{Machine Learning}
\concept{Model metrics}
