% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley.R
\name{h2o_shap}
\alias{h2o_shap}
\alias{plot.h2o_shap}
\title{SHAP values for H2O Models}
\usage{
h2o_shap(model, test = "auto", scores = "auto", y = "y", ...)

\method{plot}{h2o_shap}(x, relevant = TRUE, top = 15, quiet = FALSE, ...)
}
\arguments{
\item{model}{\code{h2o_automl} object or \code{h2o} model.}

\item{test}{String or Dataframe. Leave "auto" to use \code{h2o_automl}'s
test dataset or pass a valid dataframe.}

\item{scores}{Numeric vector. If test != "auto", you must provide predicted values}

\item{y}{Character. If test != "auto", you must provide y variable's name}

\item{...}{Additional argument for \code{predict_contributions.H2OModel}}

\item{x}{h2o_shap object}

\item{relevant}{Boolean. Keep only relevant non-trivial (>0) features}

\item{top}{Integer. Plot only top n values (as in importance)}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be shown.}
}
\value{
H2OFrame with shap values for every observation and feature.
}
\description{
SHAP (SHapley Additive exPlanations) by Lundberg and Lee (2016) is a
method to explain individual predictions. SHAP is based on the game
theoretically optimal Shapley Values. Calculate SHAP values for
h2o models in which each row is an observation and each column a feature.
Use \code{plot} method to visualize features importance and distributions.
}
\examples{
\dontrun{
# Train a h2o_automl model
model <- h2o_automl(dft, Survived,
  max_models = 1, target = TRUE,
  ignore = c("Ticket", "Cabin", "PassengerId"),
  quiet = TRUE
)

# Calculate SHAP values
SHAP_values <- h2o_shap(model)
# Equivalent to:
# SHAP_values <- h2o_shap(
#  model = model$model,
#  test = model$datasets$test,
#  scores = model$scores_test$scores)

# Check SHAP results
head(SHAP_values)

# You must have "ggbeeswarm" library to use this auxiliary function:
# Plot SHAP values (feature importance)
plot(SHAP_values)

# Plot some of the variables (categorical)
shap_var(SHAP_values, Pclass)

# Plot some of the variables (numerical)
shap_var(SHAP_values, Fare)
}
}
\seealso{
Other SHAP: 
\code{\link{shap_var}()}
}
\concept{SHAP}
