% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-colsteps.R
\name{guide_colsteps}
\alias{guide_colsteps}
\title{Custom colour steps guide}
\usage{
guide_colsteps(
  title = waiver(),
  key = "bins",
  first_guide = "axis_base",
  second_guide = "axis_base",
  shape = "triangle",
  size = NULL,
  show = NA,
  alpha = NA,
  reverse = FALSE,
  oob = scales::oob_keep,
  theme = NULL,
  position = waiver(),
  vanilla = TRUE,
  available_aes = c("colour", "fill")
)
}
\arguments{
\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{key}{A \link[=key_bins]{bins key} specificiation. Defaults to
\code{key_bins(even.steps = FALSE, show.limits = NULL)}. Changing the
arguments to \code{key_bins()} is fine, but changing the key type is not
advised.}

\item{first_guide, second_guide}{Guides to flank the colour steps. Each guide
can be specified using one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}

The \code{first_guide} will be placed at the location specified by the
\code{legend.text.position} theme setting. The \code{second_guide} will be placed
opposite that position. When \code{second_guide} has a label suppression
mechanism, no labels will be drawn for that guide.}

\item{shape}{A \link[=cap_options]{cap} specification by providing one of the
following:
\itemize{
\item A cap \verb{<function>}, such as \code{cap_triangle()}.
\item A \verb{<character[1]>} naming a cap function without the '\code{cap_}'-prefix,
e.g. \code{"round"}.
\item A two column \verb{<matrix[n, 2]>} giving coordinates for a cap, like those
created by cap functions such as \code{cap_arch()}.
}}

\item{size}{A \code{\link[grid:unit]{<unit>}} setting the size of the cap. When
\code{NULL} (default), cap size will be proportional to the \code{shape} coordinates
and the \code{legend.key.size} theme setting.}

\item{show}{A \verb{<logical>} to control how caps are displayed at the ends
of the bar. When \code{TRUE}, caps are always displayed. When \code{FALSE}, caps
are never displayed. When \code{NA} (default), caps are displayed when the
data range exceed the limits. When given as \verb{<logical[2]>}, \code{show[1]}
controls the display at the lower end and \code{show[2]} at the upper end.}

\item{alpha}{A \verb{<numeric[1]>} between 0 and 1 setting the colour transparency
of the bar. Use \code{NA} to preserve the alpha encoded in the colour itself.}

\item{reverse}{A \verb{<logical[1]>} whether to reverse continuous guides.
If \code{TRUE}, guides like colour bars are flipped. If \code{FALSE} (default),
the original order is maintained.}

\item{oob}{An out-of-bounds handling function that affects the cap colour.
Can be one of the following:
\itemize{
\item A \verb{<function>} like \code{\link[scales:oob]{oob_squish}}.
\item A \verb{<character[1]>} naming such a function without the '\code{oob}'-prefix,
such as \code{"keep"}.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{vanilla}{A \verb{<logical[1]>} whether to have the default style match
the vanilla \code{guide_colourbar()} (\code{TRUE}) or take the theme
verbatim (\code{FALSE}).}

\item{available_aes}{A \verb{<character>} vector listing the aesthetics for which this guide can
be build.}
}
\value{
A \verb{<Guide>} object
}
\description{
Similar to \code{\link[ggplot2:guide_coloursteps]{guide_coloursteps()}}, this guide
displays continuous \code{colour} or \code{fill} aesthetics. It has additional options
to display caps at the end of the bar, depending on out-of-bounds values.
}
\details{
As steps are rendered as clipped rectangles, it is important to use a
graphics device that can render clipped paths. This can be checked by using
\code{\link[ggplot2:check_device]{check_device("clippingPaths")}}.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(colour = cty))

# The colour steps show caps when values are out-of-bounds
p + scale_colour_viridis_b(
  limits = c(10, NA),
  guide = "colsteps"
)

# It also shows how oob values are handled
p + scale_colour_viridis_b(
  limits = c(10, 30), oob = scales::oob_censor,
  guide = "colsteps"
)

# Adjusting the type of cap
p + scale_colour_viridis_b(
  limits = c(10, 30),
  guide = guide_colsteps(shape = "round")
)

# The default is to use the breaks as-is
p + scale_colour_viridis_b(
  limits = c(10, 30), breaks = c(10, 20, 25),
  guide = "colsteps"
)

# But the display can be set to use evenly spaced steps
p + scale_colour_viridis_b(
  limits = c(10, 30), breaks = c(10, 20, 25),
  guide = guide_colsteps(key = key_bins(even.steps = TRUE))
)

# Using tick marks by swapping side guides
p + scale_colour_viridis_b(
  guide = guide_colsteps(
    first_guide  = "axis_base",
    second_guide = "axis_base"
  )
)
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_dendro}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_circles}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
