% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-circles.R
\name{guide_circles}
\alias{guide_circles}
\title{Circle size guide}
\usage{
guide_circles(
  key = NULL,
  title = waiver(),
  theme = NULL,
  hjust = 0.5,
  vjust = 0,
  text_position = NULL,
  clip_text = FALSE,
  override.aes = list(shape = 1),
  position = waiver(),
  direction = NULL
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. Defaults to
\code{\link[=key_auto]{key_auto()}}. See more information in the linked topic.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{hjust, vjust}{A \verb{<numeric[1]>} between 0 and 1 giving the horizontal
and vertical justification, respectively, of the central shapes. It is
recommended \code{hjust = 0.5} when text is placed on the left or right and
\code{vjust = 0.5} is recommended when text is placed on top or in the bottom.}

\item{text_position}{A string, one of \code{"ontop"}, \code{"top"}, \code{"right"},
\code{"bottom"}, or \code{"left"} do describe the placement of labels. The
default (\code{NULL}), will take the \code{legend.text.position} theme setting.}

\item{clip_text}{A \verb{<logical[1]>} whether to give text in the \code{"ontop"}
position a small rectangle of background colour.}

\item{override.aes}{A named \verb{<list>} specifying aesthetic parameters of the
key glyphs. See details and examples in
\code{\link[ggplot2:guide_legend]{guide_legend()}}.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}
}
\value{
A \verb{<GuideCircles>} object.
}
\description{
This guide displays the sizes of points as a series of circles. It is
typically paired with \code{\link[ggplot2:geom_point]{geom_point()}} with
\code{\link[ggplot2:draw_key]{draw_key_point()}} glyphs.
}
\details{
Please note that the default size scales scale to area, not radius, so
equidistant breaks will appear at irregularly spaced positions due to
labelling the diameter of a circle.

This graph was designed with standard round \link[ggplot2:scale_shape]{shapes}
in mind, i.e. shapes 1, 16, 19 and 21. For that reason, \code{shape = 1} is the
default \code{override.aes} argument. Other shapes will probably be drawn but the
quality of their alignment and label placement may be unsatisfactory.
}
\examples{
# A standard plot
p <- ggplot(mtcars, aes(disp, mpg)) +
  geom_point(aes(size = hp), alpha = 0.3)

# By default, the sizes aren't large enough to make this guide clear
p + scale_size_area(guide = "circles")

# Update with a more approrpriate scale
p <- p +
  scale_size_area(
    max_size = 30,
    limits = c(0, NA),
    breaks = c(0, 25, 100, 250)
  )
p + guides(size = "circles")

# Horizontal orientation
p + guides(size = guide_circles(
  vjust = 0.5, hjust = 0, text_position = "bottom"
))

# Alternative text placement
p + guides(size = guide_circles(
  text_position = "ontop",
  clip_text = TRUE
))

# More styling options
p + guides(size = guide_circles(override.aes = aes(colour = "red")))+
  theme(
    # Key background
    legend.key = element_rect(colour = "black", fill = 'white'),
    # Padding around central shapes
    legendry.legend.key.margin = margin(1, 1, 1, 1, "cm"),
    legend.ticks = element_line(colour = "blue"),
    legend.text.position = "left"
  )
}
\seealso{
Other standalone guides: 
\code{\link{guide_axis_base}()},
\code{\link{guide_axis_dendro}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_colbar}()},
\code{\link{guide_colring}()},
\code{\link{guide_colsteps}()},
\code{\link{guide_legend_base}()},
\code{\link{guide_legend_cross}()},
\code{\link{guide_legend_group}()}
}
\concept{standalone guides}
