% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logger.R
\name{LoggerGlue}
\alias{LoggerGlue}
\title{LoggerGlue}
\description{
\code{LoggerGlue} uses \code{\link[glue:glue]{glue::glue()}} instead of \code{\link[base:sprintf]{base::sprintf()}} to construct
log messages. \strong{glue} is a very well designed package for
string interpolation. It makes composing log messages
more flexible and comfortable at the price of an additional dependency and
slightly less performance than \code{sprintf()}.
}
\details{
\code{glue()} lets you define temporary named variables inside the call.
As with the normal Logger, these named arguments get turned into custom
fields; however, you can suppress this behaviour by making named argument
start with a \code{"."}. Please refer to \code{vignette("lgr", package = "lgr")} for
examples.
}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Logger]{lgr::Logger}} -> \code{LoggerGlue}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LoggerGlue-fatal}{\code{LoggerGlue$fatal()}}
\item \href{#method-LoggerGlue-error}{\code{LoggerGlue$error()}}
\item \href{#method-LoggerGlue-warn}{\code{LoggerGlue$warn()}}
\item \href{#method-LoggerGlue-info}{\code{LoggerGlue$info()}}
\item \href{#method-LoggerGlue-debug}{\code{LoggerGlue$debug()}}
\item \href{#method-LoggerGlue-trace}{\code{LoggerGlue$trace()}}
\item \href{#method-LoggerGlue-log}{\code{LoggerGlue$log()}}
\item \href{#method-LoggerGlue-list_log}{\code{LoggerGlue$list_log()}}
\item \href{#method-LoggerGlue-spawn}{\code{LoggerGlue$spawn()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-add_filter'><code>lgr::Filterable$add_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter"><a href='../../lgr/html/Filterable.html#method-Filterable-filter'><code>lgr::Filterable$filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter"><a href='../../lgr/html/Filterable.html#method-Filterable-remove_filter'><code>lgr::Filterable$remove_filter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters"><a href='../../lgr/html/Filterable.html#method-Filterable-set_filters'><code>lgr::Filterable$set_filters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="add_appender"><a href='../../lgr/html/Logger.html#method-Logger-add_appender'><code>lgr::Logger$add_appender()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="config"><a href='../../lgr/html/Logger.html#method-Logger-config'><code>lgr::Logger$config()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="handle_exception"><a href='../../lgr/html/Logger.html#method-Logger-handle_exception'><code>lgr::Logger$handle_exception()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="initialize"><a href='../../lgr/html/Logger.html#method-Logger-initialize'><code>lgr::Logger$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="remove_appender"><a href='../../lgr/html/Logger.html#method-Logger-remove_appender'><code>lgr::Logger$remove_appender()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_appenders"><a href='../../lgr/html/Logger.html#method-Logger-set_appenders'><code>lgr::Logger$set_appenders()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_exception_handler"><a href='../../lgr/html/Logger.html#method-Logger-set_exception_handler'><code>lgr::Logger$set_exception_handler()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_propagate"><a href='../../lgr/html/Logger.html#method-Logger-set_propagate'><code>lgr::Logger$set_propagate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_threshold"><a href='../../lgr/html/Logger.html#method-Logger-set_threshold'><code>lgr::Logger$set_threshold()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-fatal"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-fatal}{}}}
\subsection{Method \code{fatal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$fatal(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-error"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-error}{}}}
\subsection{Method \code{error()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$error(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-warn"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-warn}{}}}
\subsection{Method \code{warn()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$warn(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-info"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-info}{}}}
\subsection{Method \code{info()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$info(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-debug"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-debug}{}}}
\subsection{Method \code{debug()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$debug(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-trace"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-trace}{}}}
\subsection{Method \code{trace()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$trace(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-log"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-log}{}}}
\subsection{Method \code{log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$log(
  level,
  ...,
  timestamp = Sys.time(),
  caller = get_caller(-7),
  .envir = parent.frame()
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-list_log"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-list_log}{}}}
\subsection{Method \code{list_log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$list_log(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggerGlue-spawn"></a>}}
\if{latex}{\out{\hypertarget{method-LoggerGlue-spawn}{}}}
\subsection{Method \code{spawn()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$spawn(name)}\if{html}{\out{</div>}}
}

}
}
