% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likert.R
\name{likert}
\alias{likert}
\title{Analyze Likert type items.}
\usage{
likert(items, summary, grouping = NULL, factors = NULL, importance,
  nlevels = length(levels(items[, 1])))
}
\arguments{
\item{items}{data frame containing the likert based items. The variables
in the data frame should be factors.}

\item{summary}{a pre-summarized data frame. The first column must be the
items and the remaining columns are the levels (e.g. strongly disagree,
disagree, etc).}

\item{grouping}{(optional) should the results be summarized by the given
grouping variable.}

\item{factors}{a vector with \code{length(factors) == ncol(items)}
defining which factor each column belongs to. The values correspond
to the factor label.}

\item{importance}{a data frame of the same dimensions as items containing
an importance rating for each item. The order of columns should match
and the names from items will be used.}

\item{nlevels}{number of possible levels. Only necessary if there are missing levels.}
}
\value{
a likert class with the following elements: results, items, grouping,
       nlevels, and summary.
}
\description{
This function will provide various statistics about a set of likert
items. The resulting object will have the following items:
}
\details{
\itemize{
   \item \code{results} - this data frame will contain a column 'Item', 'Group' (if a 
         grouping variable was specified, and a column for each level of the
         items (e.g. agree, disagree, etc.). The value within each cell corresponds
         to the percentage of responses for that level and group.
   \item \code{items} - a copy of the original items data frame.
   \item \code{grouping} - a copy of the original grouping vector.
   \item \code{nlevels} - the number of levels used in the calculations.
}
}
\examples{
data(pisaitems)
items29 <- pisaitems[,substr(names(pisaitems), 1,5) == 'ST25Q']
names(items29) <- c("Magazines", "Comic books", "Fiction", 
                   "Non-fiction books", "Newspapers")
l29 <- likert(items29)
summary(l29)
plot(l29)
}
\seealso{
plot.likert

summary.likert
}

