% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{lologPackageSkeleton}
\alias{lologPackageSkeleton}
\title{Create a skeleton for a package extending lolog}
\usage{
lologPackageSkeleton(path = ".")
}
\arguments{
\item{path}{where to create the package}
}
\description{
Create a skeleton for a package extending lolog
}
\details{
lolog is a modular package, and can be extended at 
both the R and C++ level. This function will build a package
skeleton that can be used as a starting point for
development. To create the package in the current directory
run:

\code{lologPackageSkeleton()}

Build and install the package from the command line with

\code{R CMD build LologExtension}

\code{R CMD INSTALL LologExtension_1.0.tar.gz}
}
\examples{

\dontrun{

#install package
lologPackageSkeleton()
system("R CMD build LologExtension")
system("R CMD INSTALL LologExtension_1.0.tar.gz")

library(LologExtension) #Load package

# Run model with new minDegree statistic
library(network)
m <- matrix(0,20,20)
for(i in 1:19) for(j in (i+1):20) m[i,j] <- m[j,i] <- rbinom(1,1,.1)
g <- network(m, directed=FALSE)
fit <- lologVariational(g ~ edges() + minDegree(1L))
summary(fit)

}
}
\seealso{
\code{\link{inlineLologPlugin}}
}
