% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dal.R
\name{dal}
\alias{dal}
\title{Density of the Asymmetric Laplace distribution}
\usage{
dal(y, mu = 0, sigma = 1, qtl = 0.5, log = FALSE)
}
\arguments{
\item{y}{vector of quantiles}

\item{mu}{location parameter}

\item{sigma}{scale parameter}

\item{qtl}{skewness parameter}

\item{log}{logical; if TRUE, probabilities are log-transformed}
}
\value{
Return the density for the asymmetric Laplace distribution
}
\description{
Compute the density for the three parameter Asymmetric Laplace Distribution
}
\details{
The function computes the density of the Asymmetric Laplace distribution, with location \eqn{\mu}, scale \eqn{\sigma > 0}
and skewness \code{qtl = q} in (0,1), as discussed by Koenker and Machado (1999) and Yu and Moyeed (2001), according to the following expression

\deqn{f(y | \mu, \sigma, q) = \frac{q(1-q)}{\sigma} \exp(-\rho_{q} (\frac{y-\mu}{\sigma}))}
}
\references{
{
  \insertRef{ref:dal1}{lqmix}
}

{
  \insertRef{ref:dal2}{lqmix}
}
}
