% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_flags.R
\name{get_flags}
\alias{get_flags}
\title{Get the flags of pipelines in a MaestroSchedule object}
\usage{
get_flags(schedule)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}
}
\value{
data.frame
}
\description{
Creates a long data.frame where each row is a flag for each pipeline.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  get_flags(schedule)

  # Alternatively, use the underlying R6 method
  schedule$get_flags()
}
}
