% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compare_analyses}
\alias{compare_analyses}
\title{Compare Two Analysis Results}
\usage{
compare_analyses(results1, results2, nutrient = "nitrogen")
}
\arguments{
\item{results1}{First analysis results}

\item{results2}{Second analysis results}

\item{nutrient}{Character. Nutrient to compare ("nitrogen" or "phosphorus")}
}
\value{
Data frame with comparison
}
\description{
Compare classifications between two analysis results
}
\examples{
\donttest{
results_2010 <- run_builtin_analysis(scale = "county", year = 2010)
results_2016 <- run_builtin_analysis(scale = "county", year = 2016)
comparison <- compare_analyses(results_2010, results_2016, "nitrogen")
}
}
