% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_constraints.R
\name{set_constraints}
\alias{set_constraints}
\title{Set up a system of linear equality and/or inequality constraints}
\usage{
set_constraints(
  R = NULL,
  r = NULL,
  S = NULL,
  s = NULL,
  S2 = NULL,
  l2 = NULL,
  u2 = NULL,
  scale = FALSE
)
}
\arguments{
\item{R}{equality constraint matrix each column of which corresponds to a constraint.}

\item{r}{right-hand side vector for equality constraints \eqn{R'x = r}, where \eqn{R'} denotes the transpose of R.}

\item{S}{inequality constraint matrix each column of which corresponds to an inequality constraint.}

\item{s}{rhs vector for inequality constraints \eqn{S'x >= s}, where \eqn{S'} denotes the transpose of S.}

\item{S2}{inequality constraint matrix each column of which corresponds to a two-sided inequality constraint.}

\item{l2}{vector of lower bounds for two-sided inequality constraints \eqn{l_2 <= S_2'x <= u_2}.}

\item{u2}{vector of upper bounds for two-sided inequality constraints \eqn{l_2 <= S_2'x <= u_2}.}

\item{scale}{whether to scale the columns of all constraint matrices to unit Euclidean norm.}
}
\value{
An environment with constraint matrices and vectors and a method to check whether a numeric vector
 satisfies all constraints. Returns \code{NULL} in case of no constraints.
}
\description{
Two-sided inequalities specified by \code{S2, l2, u2} are currently
transformed into the one-sided form \eqn{S'x >= s}, combined with
any directly specified constraints of this form. Some basic consistency
checks are carried out, notably regarding the dimensions of the inputs.
}
