% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-object.R
\name{meta-object}
\alias{meta-object}
\title{Description of R object of class "meta"}
\description{
Detailed description of R objects of class "meta".
}
\details{
The following R functions create an object of class \code{"meta"}:
\itemize{
\item \code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metacor}}, \code{\link{metagen}},
  \code{\link{metainc}}, \code{\link{metamean}},
  \code{\link{metaprop}}, \code{\link{metarate}},
  \code{\link{metacr}}, \code{\link{metamerge}},
  \code{\link{trimfill}}
}

The following generic functions are available for an object of
class \code{"meta"}:

\itemize{
\item \code{\link{as.data.frame.meta}}, \code{\link{labels.meta}},
  \code{\link{print.meta}}, \code{\link{print.summary.meta}},
  \code{\link{summary.meta}}, \code{\link{update.meta}},
  \code{\link{weights.meta}}
}

An object of class \code{"meta"} is a list containing the following
components.
\tabular{ll}{
\code{studlab} \tab Study labels \cr
\code{sm} \tab Effect measure \cr
\code{null.effect} \tab Effect under the null hypothesis \cr
\code{TE} \tab Effect estimates (individual studies) \cr
\code{seTE} \tab Standard error of effect estimates (individual studies) \cr
\code{statistic} \tab Statistics for test of effect (individual studies) \cr
\code{pval} \tab P-values for test of effect (individual studies) \cr
\code{df} \tab Degrees of freedom (individual studies) \cr
\code{level} \tab Level of confidence intervals for individual studies \cr
\code{lower} \tab Lower confidence limits (individual studies) \cr
\code{upper} \tab Upper confidence limits (individual studies) \cr
\code{three.level} \tab Indicator variable for three-level
  meta-analysis model \cr
\code{cluster} \tab Cluster variable (three-level meta-analysis
  model) \cr
\code{rho} \tab Within-cluster correlation (three-level
  meta-analysis model) \cr
\code{k} \tab Number of estimates combined in meta-analysis \cr
\code{k.study} \tab Number of studies combined in meta-analysis \cr
\code{k.all} \tab Number of all studies \cr
\code{k.TE} \tab Number of studies with estimable effects \cr
\code{overall} \tab Print meta-analysis results \cr
\code{overall.hetstat} \tab Print overall heterogeneity statistics \cr
\code{common} \tab Print results for common effect meta-analysis \cr
\code{random} \tab Print results for random effects meta-analysis \cr
\code{prediction} \tab Print prediction interval \cr
\code{backtransf} \tab Back transform results in printouts and plots \cr
\code{method} \tab Meta-analysis method (common effect model) \cr
\code{method.random} \tab Meta-analysis method (random effects model) \cr
\code{w.common} \tab Weights for common effect model (individual studies) \cr
\code{TE.common} \tab Estimated overall effect (common effect model) \cr
\code{seTE.common} \tab Standard error of overall effect (common effect model) \cr
\code{statistic.common} \tab Statistic for test of overall effect (common effect model) \cr
\code{pval.common} \tab P-value for test of overall effect (common effect model) \cr
\code{level.ma} \tab Level of confidence interval for meta-analysis
  estimates \cr
\code{lower.common} \tab Lower confidence limit (common effect model) \cr
\code{upper.common} \tab Upper confidence limit (common effect model) \cr
\code{w.random} \tab Weight for random effects model (individual studies) \cr
\code{TE.random} \tab Estimated overall effect (random effects model) \cr
\code{seTE.random} \tab Standard error of overall effect (random effects model) \cr
\code{statistic.random} \tab Statistic for test of overall effect (random effects model) \cr
\code{pval.random} \tab P-value for test of overall effect (random effects model) \cr
\code{method.random.ci} \tab Confidence interval method (random effects model) \cr
\code{df.random} \tab Degrees of freedom (random effects model) \cr
\code{lower.random} \tab Lower confidence limit (random effects model) \cr
\code{upper.random} \tab Upper confidence limit (random effects model) \cr
\code{seTE.classic} \tab Standard error (classic random effects method) \cr
\code{adhoc.hakn.ci} \tab \emph{Ad hoc} correction for
  Hartung-Knapp method (confidence interval) \cr
\code{df.hakn.ci} \tab Degrees of freedom for Hartung-Knapp method
  \cr \tab (if used in meta-analysis) \cr
\code{seTE.hakn.ci} \tab Standard error for Hartung-Knapp method
  \cr
\tab (not taking \emph{ad hoc} variance correction into account)
  \cr
\code{seTE.hakn.adhoc.ci} \tab Standard error for Hartung-Knapp
  method \cr
\tab (taking \emph{ad hoc} variance correction into account) \cr
\code{df.kero} \tab Degrees of freedom for Kenward-Roger method \cr
\tab  (if used in meta-analysis) \cr 
\code{seTE.kero} \tab Standard error for Kenward-Roger
  method \cr
\code{method.predict} \tab Method to calculate prediction interval \cr
\code{adhoc.hakn.pi} \tab \emph{Ad hoc} correction for
  Hartung-Knapp method (prediction interval) \cr
\code{df.hakn.ci} \tab Degrees of freedom for Hartung-Knapp method
  \cr \tab (prediction interval) \cr
\code{seTE.predict} \tab Standard error used to calculate
  prediction interval \cr
\code{df.predict} \tab Degrees of freedom for prediction interval \cr
\code{level.predict} \tab Level of prediction interval \cr
\code{lower.predict} \tab Lower limit of prediction interval \cr
\code{upper.predict} \tab Upper limit of prediction interval \cr
\code{seTE.hakn.pi} \tab Standard error for Hartung-Knapp method
  \cr
\tab (not taking \emph{ad hoc} variance correction into account)
  \cr
\code{seTE.hakn.adhoc.pi} \tab Standard error for Hartung-Knapp
  method \cr
\tab (taking \emph{ad hoc} variance correction into account) \cr
\code{Q} \tab Heterogeneity statistic \cr
\code{df.Q} \tab Degrees of freedom for heterogeneity statistic
  \code{Q} \cr
\code{pval.Q} \tab P-value of heterogeneity test \cr
\code{method.tau} \tab Method to estimate between-study variance \eqn{\tau^2} \cr
\code{control} \tab Additional arguments for iterative estimation
  of \eqn{\tau^2} \cr
\code{method.tau.ci} \tab Method for confidence interval of \eqn{\tau^2} \cr
\code{level.hetstat} \tab Level of confidence intervals for heterogeneity
  statistics \cr
\code{tau2} \tab Between-study variance \eqn{\tau^2} \cr
\code{se.tau2} \tab Standard error of \eqn{\tau^2} \cr
\code{lower.tau2} \tab Lower confidence limit (\eqn{\tau^2}) \cr
\code{upper.tau2} \tab Upper confidence limit (\eqn{\tau^2}) \cr
\code{tau} \tab Square-root of between-study variance \eqn{\tau} \cr
\code{lower.tau} \tab Lower confidence limit (\eqn{\tau}) \cr
\code{upper.tau} \tab Upper confidence limit (\eqn{\tau}) \cr
\code{tau.preset} \tab Prespecified value for \eqn{\tau} \cr
\code{TE.tau} \tab Effect estimate used to estimate \eqn{\tau^2} \cr
\code{detail.tau} \tab Detail on between-study variance estimate \cr
\code{phi} \tab Multiplicative heterogeneity parameter \eqn{phi} in
  penalised logistic regression \cr
\code{H} \tab Heterogeneity statistic H \cr
\code{lower.H} \tab Lower confidence limit (heterogeneity statistic H) \cr
\code{upper.H} \tab Upper confidence limit (heterogeneity statistic H) \cr
\code{I2} \tab Heterogeneity statistic I\eqn{^2} \cr
\code{lower.I2} \tab Lower confidence limit (heterogeneity statistic I\eqn{^2}) \cr
\code{upper.I2} \tab Upper confidence limit (heterogeneity statistic I\eqn{^2}) \cr
\code{Rb} \tab Heterogeneity statistic R\eqn{_b} \cr
\code{lower.Rb} \tab Lower confidence limit (heterogeneity statistic R\eqn{_b}) \cr
\code{upper.Rb} \tab Upper confidence limit (heterogeneity statistic R\eqn{_b}) \cr
\code{method.bias} \tab Method to test for funnel plot asymmetry \cr
\code{text.common} \tab Label for common effect model \cr
\code{text.random} \tab Label for random effects model \cr
\code{text.predict} \tab Label for prediction interval \cr
\code{text.w.common} \tab Label for weights (common effect model) \cr
\code{text.w.random} \tab Label for weights (random effects model) \cr
\code{title} \tab Title of meta-analysis / systematic review \cr
\code{complab} \tab Comparison label \cr
\code{outclab} \tab Outcome label \cr
\code{label.e} \tab Label for experimental group \cr
\code{label.c} \tab Label for control group \cr
\code{label.left} \tab Graph label on left side of forest plot \cr
\code{label.right} \tab Graph label on right side of forest plot \cr
\code{keepdata} \tab Keep original data \cr
\code{data} \tab Original data (set) used in function call (if
  \code{keepdata = TRUE}) \cr
\code{subset} \tab Information on subset of original data used in
  meta-analysis \cr
\tab (if \code{keepdata = TRUE}) \cr
\code{exclude} \tab Studies excluded from meta-analysis \cr
\code{warn} \tab Print warnings \cr
\code{call} \tab Function call \cr
\code{version} \tab Version of R package \bold{meta} used to create
  object
}

For subgroup analysis (argument \code{subgroup}), the following
additional components are added to the list.
\tabular{ll}{
\code{subgroup} \tab Subgroup information (for individual studies) \cr
\code{subgroup.name} \tab Name of subgroup variable \cr
\code{print.subgroup.name} \tab Print name of subgroup variable \cr
\code{sep.subgroup} \tab Separator between name of subgroup variable and value \cr
\code{test.subgroup} \tab Print test for subgroup differences \cr
\code{prediction.subgroup} \tab Print prediction interval for subgroup(s) \cr
\code{tau.common} \tab Assumption of common between-study variance in subgroups \cr
\code{subgroup.levels} \tab Levels of grouping variable \cr
\code{k.w} \tab Number of estimates combined in subgroups \cr
\code{k.study.w} \tab Number of studies combined in subgroups
  \cr
\code{k.all.w} \tab Number of studies in subgroups \cr
\code{k.TE.w} \tab Number of studies with estimable effects
  in subgroups \cr
\code{TE.common.w} \tab Estimated effect in subgroups (common
  effect model) \cr
\code{seTE.common.w} \tab Standard error in subgroups (common effect model) \cr
\code{statistic.common.w} \tab Statistic for test of effect in subgroups (common effect model) \cr
\code{pval.common.w} \tab P-value for test of effect in subgroups (common effect model) \cr
\code{lower.common.w} \tab Lower confidence limit in subgroups (common effect model) \cr
\code{upper.common.w} \tab Upper confidence limit in subgroups (common effect model) \cr
\code{w.common.w} \tab Total weight in subgroups (common effect model) \cr
\code{TE.random.w} \tab Estimated effect in subgroups (random
  effect model) \cr
\code{seTE.random.w} \tab Standard error in subgroups (random effects model) \cr
\code{statistic.random.w} \tab Statistic for test of effect in subgroups (random effects model) \cr
\code{pval.random.w} \tab P-value for test of effect in subgroups (random effects model) \cr
\code{df.random.w} \tab Degrees of freedom in subgroups (random effects model) \cr
\code{lower.random.w} \tab Lower confidence limit in subgroups (random effects model) \cr
\code{upper.random.w} \tab Upper confidence limit in subgroups (random effects model) \cr
\code{w.random.w} \tab Total weight in subgroups (random effects model) \cr
\code{seTE.classic.w} \tab Standard error (classic random effects method) \cr
\code{df.hakn.ci.w} \tab Degrees of freedom for Hartung-Knapp
  method in subgroups \cr
\code{seTE.hakn.ci.w} \tab Standard error for Hartung-Knapp method in subgroups
  \cr
\tab (not taking \emph{ad hoc} variance correction into account)
  \cr
\code{seTE.hakn.adhoc.ci.w} \tab Standard error for Hartung-Knapp
  method in subgroups \cr
\code{df.kero.w} \tab Degrees of freedom for Kenward-Roger method in subgroups \cr 
\code{seTE.kero.w} \tab Standard error for Kenward-Roger
  method in subgroups \cr
\code{seTE.predict.w} \tab Standard error for prediction interval in subgroups \cr
\code{df.predict.w} \tab Degrees of freedom for prediction interval in subgroups \cr
\code{lower.predict.w} \tab Lower limit of prediction interval in subgroups \cr
\code{upper.predict.w} \tab Upper limit of prediction interval in subgroups \cr
\code{seTE.hakn.pi.w} \tab Standard error for Hartung-Knapp method in subgroups (prediction intervals)
  \cr
\tab (not taking \emph{ad hoc} variance correction into account)
  \cr
\code{seTE.hakn.adhoc.pi.w} \tab Standard error for Hartung-Knapp
  method in subgroups (prediction intervals) \cr
\code{Q.w} \tab Heterogeneity statistic Q in subgroups \cr
\code{pval.Q.w} \tab P-value for test of heterogeneity in subgroups \cr
\code{tau2.w} \tab Between-study variance \eqn{\tau^2} in subgroups \cr
\code{tau.w} \tab Square-root of between-study variance \eqn{\tau} in subgroups \cr
\code{H.w} \tab Heterogeneity statistic H in subgroups \cr
\code{lower.H.w} \tab Lower confidence limit for H in subgroups \cr
\code{upper.H.w} \tab Upper confidence limit for H in subgroups \cr
\code{I2.w} \tab Heterogeneity statistic I\eqn{^2} in subgroups \cr
\code{lower.I2.w} \tab Lower confidence limit for I\eqn{^2} in subgroups \cr
\code{upper.I2.w} \tab Upper confidence limit for I\eqn{^2} in subgroups \cr
\code{Rb.w} \tab Heterogeneity statistic R\eqn{_b} in subgroups \cr
\code{lower.Rb.w} \tab Lower confidence limit for R\eqn{_b} in subgroups \cr
\code{upper.Rb.w} \tab Upper confidence limit for R\eqn{_b} in subgroups \cr
\code{Q.w.common} \tab Within-group heterogeneity statistic Q
  (common effect model) \cr
\code{Q.w.random} \tab Within-group heterogeneity statistic
  Q (random effects model) \cr
\tab (only calculated if argument \code{tau.common = TRUE}) \cr
\code{df.Q.w} \tab Degrees of freedom for \code{Q.w.common} and \code{Q.w.random} \cr
\code{pval.Q.w.common} \tab P-value of test for residual
  heterogeneity (common effect model) \cr
\code{pval.Q.w.random} \tab P-value of test for residual
  heterogeneity (random effects model) \cr
\code{Q.b.common} \tab Between-groups heterogeneity statistic
  Q (common effect model) \cr
\code{df.Q.b.common} \tab Degrees of freedom for \code{Q.b.common}
  \cr
\code{pval.Q.b.common} \tab P-value of test for subgroup
  differences (common effect model) \cr
\code{Q.b.random} \tab Between-groups heterogeneity statistic
  Q (random effects model) \cr
\code{df.Q.b.random} \tab Degrees of freedom for \code{Q.b.random}
  \cr
\code{pval.Q.b.random} \tab P-value of test for subgroup
  differences (random effects model)
}

For subgroup analysis assuming a common between-study variance in subgroups
(argument \code{tau.common = TRUE}), the following additional components are
added to the list.
\tabular{ll}{
\code{tau2.resid} \tab Residual between-study variance after accounting for
  \cr
\code{} \tab subgroup differences  (equal to entries in list element
  \code{tau2.w}) \cr
\code{lower.tau2.resid} \tab Lower confidence limit \cr
\code{upper.tau2.resid} \tab Upper confidence limit \cr
\code{tau.resid} \tab Square-root of residual between-study variance \cr
\code{lower.tau.resid} \tab Lower confidence limit \cr
\code{upper.tau.resid} \tab Upper confidence limit \cr
\code{H.resid} \tab Heterogeneity statistic H after accounting for
  subgroup differences \cr
\code{lower.H.resid} \tab Lower confidence limit \cr
\code{upper.H.resid} \tab Upper confidence limit \cr
\code{I2.resid} \tab Heterogeneity statistic I\eqn{^2} after accounting for
  subgroup differences \cr
\code{lower.I2.resid} \tab Lower confidence limit \cr
\code{upper.I2.resid} \tab Upper confidence limit \cr
\code{Q.resid} \tab Heterogeneity statistic for residual heterogeneity \cr
\code{df.Q.resid} \tab Degrees of freedom for heterogeneity statistic
  \code{Q.resid} \cr
\code{pval.Q.resid} \tab P-value of test for residual heterogeneity \cr
}

An object created with \code{\link{metabin}} has the additional
class \code{"metabin"} and the following components.

\tabular{ll}{
\code{event.e} \tab Events in experimental group (individual
  studies) \cr
\code{n.e} \tab Sample size in experimental group (individual
  studies) \cr
\code{event.e} \tab Events in control group (individual studies)
  \cr
\code{n.e} \tab Sample size in control group (individual studies)
  \cr
\code{incr} \tab Increment added to zero cells \cr
\code{method.incr} \tab Continuity correction method \cr
\code{sparse} \tab Continuity correction applied \cr
\code{allstudies} \tab Include studies with double zeros \cr
\code{doublezeros} \tab Indicator for studies with double zeros \cr
\code{MH.exact} \tab Exact Mantel-Haenszel method \cr
\code{RR.Cochrane} \tab Cochrane method to calculate risk ratio \cr
\code{Q.Cochrane} \tab Cochrane method to calculate \eqn{\tau^2}
  \cr
\code{Q.CMH} \tab Cochran-Mantel-Haenszel statistic \cr
\code{df.Q.CMH} \tab Degrees of freedom for \code{Q.CMH} \cr
\code{pval.Q.CMH} \tab P-value of Cochran-Mantel-Haenszel test \cr
\code{print.CMH} \tab Print results for Cochran-Mantel-Haenszel
  statistic \cr
\code{incr.e} \tab Continuity correction in experimental group
  (individual studies) \cr
\code{incr.c} \tab Continuity correction in control group
  (individual studies) \cr
\code{k.MH} \tab Number of studies (Mantel-Haenszel method)
}

An object created with \code{\link{metacont}} has the additional
class \code{"metacont"} and the following components.

\tabular{ll}{
\code{n.e} \tab Sample size in experimental group (individual
  studies) \cr
\code{mean.e} \tab Estimated mean in experimental group (individual
  studies) \cr
\code{sd.e} \tab Standard deviation in experimental group
  (individual studies) \cr
\code{n.c} \tab Sample size in control group (individual studies)
  \cr
\code{mean.c} \tab Estimated mean in control group (individual
  studies) \cr
\code{sd.c} \tab Standard deviation in control group (individual
  studies) \cr
\code{pooledvar} \tab Use pooled variance for mean difference \cr
\code{method.smd} \tab Method for standardised mean difference
  (SMD) \cr
\code{sd.glass} \tab Denominator in Glass' method \cr
\code{exact.smd} \tab Use exact formulae for SMD \cr
\code{method.ci} \tab Method to calculate confidence limits \cr
\code{method.mean} \tab Method to approximate mean \cr
\code{method.sd} \tab Method to approximate standard deviation
}

An object created with \code{\link{metacor}} has the additional
class \code{"metacor"} and the following components.

\tabular{ll}{
\code{cor} \tab Correlation (individual studies) \cr
\code{n} \tab Sample size (individual studies)
}

An object created with \code{\link{metainc}} has the additional
class \code{"metainc"} and the following components.

\tabular{ll}{
\code{event.e} \tab Events in experimental group (individual
  studies) \cr
\code{time.e} \tab Person time in experimental group (individual
  studies) \cr
\code{n.e} \tab Sample size in experimental group (individual
  studies) \cr 
\code{event.c} \tab Events in control group (individual studies)
  \cr
\code{time.c} \tab Person time in control group (individual studies)
  \cr
\code{n.c} \tab Sample size in control group (individual studies)
  \cr
\code{incr} \tab Increment added to zero cells \cr
\code{method.incr} \tab Continuity correction method \cr
\code{sparse} \tab Continuity correction applied \cr
\code{incr.e} \tab Continuity correction in experimental group
  (individual studies) \cr
\code{incr.c} \tab Continuity correction in control group
  (individual studies) \cr
\code{k.MH} \tab Number of studies (Mantel-Haenszel method)
}

An object created with \code{\link{metamean}} has the additional
class \code{"metamean"} and the following components.

\tabular{ll}{
\code{n} \tab Sample size (individual studies) \cr
\code{mean} \tab Estimated mean (individual studies) \cr
\code{sd} \tab Standard deviation (individual studies) \cr
\code{method.ci} \tab Method to calculate confidence limits \cr
\code{method.mean} \tab Method to approximate mean \cr
\code{method.sd} \tab Method to approximate standard deviation \cr
}

An object created with \code{\link{metaprop}} has the additional
class \code{"metaprop"} and the following components.

\tabular{ll}{
\code{event} \tab Events (individual studies) \cr
\code{n} \tab Sample size (individual studies) \cr
\code{incr} \tab Increment added to zero cells \cr
\code{method.incr} \tab Continuity correction method \cr
\code{sparse} \tab Continuity correction applied \cr
\code{method.ci} \tab Method to calculate confidence limits \cr
\code{incr.event} \tab Continuity correction (individual studies)
}

An object created with \code{\link{metarate}} has the additional
class \code{"metarate"} and the following components.

\tabular{ll}{
\code{event} \tab Events (individual studies) \cr
\code{time} \tab Person time (individual studies) \cr
\code{n} \tab Sample size (individual studies) \cr
\code{incr} \tab Increment added to zero cells \cr
\code{method.incr} \tab Continuity correction method \cr
\code{sparse} \tab Continuity correction applied \cr
\code{method.ci} \tab Method to calculate confidence limits \cr
\code{incr.event} \tab Continuity correction (individual studies)
}

An object created with \code{\link{trimfill}} has the additional
classes \code{"trimfill"} and \code{"metagen"} and the following
components.

\tabular{ll}{
\code{k0} \tab Number of added studies \cr
\code{left} \tab Studies missing on left side \cr
\code{ma.common} \tab Use common effect or random effects model to
  estimate \cr
\tab number of missing studies \cr
\code{type} \tab Method to estimate missing studies \cr
\code{n.iter.max} \tab Maximum number of iterations \cr
\code{n.iter} \tab Number of iterations \cr
\code{trimfill} \tab Filled studies (individual studies) \cr
\code{class.x} \tab Primary class of meta-analysis object
}

An object created with \code{\link{metamerge}} has the additional
class \code{"metamerge"}. Furthermore, the following components
have a different meaning:

\tabular{ll}{
\code{k} \tab Vector with number of estimates \cr
\code{k.study} \tab Vector with number of studies \cr
\code{k.all} \tab Vector with total number of studies \cr
\code{k.TE} \tab Vector with number of studies with estimable
  effects \cr
\code{k.MH} \tab Vector with number of studies combined with
  Mantel-Haenszel method \cr
\code{TE.common} \tab Vector with common effect estimates \cr
\code{seTE.common} \tab Vector with standard errors of common effect
  estimates \cr
\code{lower.common} \tab Vector with lower confidence limits (common
  effect model) \cr
\code{upper.common} \tab Vector with upper confidence limits (common
  effect model) \cr
\code{statistic.common} \tab Vector with test statistics for test of
  overall effect (common effect model) \cr
\code{pval.common} \tab Vector with p-value of test for overall effect
  (common effect model) \cr
\code{TE.random} \tab Vector with random effects estimates \cr
\code{seTE.random} \tab Vector with standard errors of random effects
  estimates \cr
\code{lower.random} \tab Vector with lower confidence limits (random
  effects model) \cr
\code{upper.random} \tab Vector with upper confidence limits (random
  effects model) \cr
\code{statistic.random} \tab Vector with test statistics for test of
  overall effect (random effects model) \cr
\code{pval.random} \tab Vector with p-value of test for overall effect
  (random effects model) \cr
\code{w.common} \tab Vector or matrix with common effect weights \cr
\code{w.random} \tab Vector or matrix with random effects weights
}
}
\seealso{
\code{\link{meta-package}}, \code{\link{meta-sm}},
  \code{\link{print.meta}}, \code{\link{summary.meta}},
  \code{\link{forest.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{list}
